package de.jaggl.jetty.embedded.namespace;

import static org.springframework.beans.factory.support.BeanDefinitionBuilder.rootBeanDefinition;
import static org.springframework.beans.factory.support.BeanDefinitionReaderUtils.generateBeanName;
import static org.springframework.beans.factory.support.BeanDefinitionReaderUtils.registerBeanDefinition;
import static org.springframework.beans.factory.support.BeanDefinitionReaderUtils.registerWithGeneratedName;
import static org.springframework.util.StringUtils.hasText;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ResourceUtils;
import org.w3c.dom.Element;

public class EmbeddedBeanDefinitionParser implements BeanDefinitionParser
{

    @Override
    public AbstractBeanDefinition parse(Element element,
        ParserContext parserContext)
    {
        BeanDefinitionBuilder serverBuilder = rootBeanDefinition(Server.class);
        BeanDefinitionBuilder webAppContextBuilder = rootBeanDefinition(WebAppContext.class);
        BeanDefinitionBuilder defaultHandlerBuilder = rootBeanDefinition(DefaultHandler.class);
        BeanDefinitionBuilder handlerCollectionBuilder = rootBeanDefinition(HandlerCollection.class);
        BeanDefinitionBuilder arrayBuilder = rootBeanDefinition(HandlerHelper.class);

        try
        {
            webAppContextBuilder.addConstructorArgValue(ResourceUtils.getURL(
                element.getAttribute("webAppPath")).toExternalForm());
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }

        webAppContextBuilder.addConstructorArgValue(element
            .getAttribute("contextPath"));
        webAppContextBuilder.addPropertyValue("parentLoaderPriority",
            Boolean.TRUE);

        String webAppContextId = registerWithGeneratedName(
            webAppContextBuilder.getBeanDefinition(),
            parserContext.getRegistry());
        String defaultHandlerId = registerWithGeneratedName(
            defaultHandlerBuilder.getBeanDefinition(),
            parserContext.getRegistry());

        arrayBuilder.addConstructorArgReference(webAppContextId);
        arrayBuilder.addConstructorArgReference(defaultHandlerId);
        arrayBuilder.setFactoryMethod("getArray");

        String arrayId = registerWithGeneratedName(
            arrayBuilder.getBeanDefinition(), parserContext.getRegistry());

        handlerCollectionBuilder.addConstructorArgValue(Boolean.TRUE);
        handlerCollectionBuilder.addPropertyReference("handlers", arrayId);

        String handlerCollectionId = registerWithGeneratedName(
            handlerCollectionBuilder.getBeanDefinition(),
            parserContext.getRegistry());

        serverBuilder.addConstructorArgValue(element.getAttribute("port"));
        serverBuilder.addPropertyValue("stopAtShutdown", Boolean.TRUE);
        serverBuilder.addPropertyReference("handler", handlerCollectionId);

        serverBuilder.setInitMethodName("start");
        serverBuilder.setDestroyMethodName("stop");

        String id = element.getAttribute("id");
        if (!hasText(id))
        {
            id = generateBeanName(serverBuilder.getBeanDefinition(),
                parserContext.getRegistry());
        }

        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(
            serverBuilder.getBeanDefinition(), id);

        registerBeanDefinition(definitionHolder, parserContext.getRegistry());

        return serverBuilder.getBeanDefinition();
    }

}
