/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.jetty.embedded.namespace;

import de.jaggl.jetty.embedded.namespace.HandlerHelper;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class EmbeddedBeanDefinitionParser
implements BeanDefinitionParser {
    public AbstractBeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder serverBuilder = BeanDefinitionBuilder.rootBeanDefinition(Server.class);
        BeanDefinitionBuilder webAppContextBuilder = BeanDefinitionBuilder.rootBeanDefinition(WebAppContext.class);
        BeanDefinitionBuilder defaultHandlerBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultHandler.class);
        BeanDefinitionBuilder handlerCollectionBuilder = BeanDefinitionBuilder.rootBeanDefinition(HandlerCollection.class);
        BeanDefinitionBuilder arrayBuilder = BeanDefinitionBuilder.rootBeanDefinition(HandlerHelper.class);
        try {
            webAppContextBuilder.addConstructorArgValue((Object)ResourceUtils.getURL((String)element.getAttribute("webAppPath")).toExternalForm());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        webAppContextBuilder.addConstructorArgValue((Object)element.getAttribute("contextPath"));
        webAppContextBuilder.addPropertyValue("parentLoaderPriority", (Object)Boolean.TRUE);
        String webAppContextId = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)webAppContextBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        String defaultHandlerId = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)defaultHandlerBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        arrayBuilder.addConstructorArgReference(webAppContextId);
        arrayBuilder.addConstructorArgReference(defaultHandlerId);
        arrayBuilder.setFactoryMethod("getArray");
        String arrayId = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)arrayBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        handlerCollectionBuilder.addConstructorArgValue((Object)Boolean.TRUE);
        handlerCollectionBuilder.addPropertyReference("handlers", arrayId);
        String handlerCollectionId = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)handlerCollectionBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        serverBuilder.addConstructorArgValue((Object)element.getAttribute("port"));
        serverBuilder.addPropertyValue("stopAtShutdown", (Object)Boolean.TRUE);
        serverBuilder.addPropertyReference("handler", handlerCollectionId);
        serverBuilder.setInitMethodName("start");
        serverBuilder.setDestroyMethodName("stop");
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            id = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)serverBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)serverBuilder.getBeanDefinition(), id);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)parserContext.getRegistry());
        return serverBuilder.getBeanDefinition();
    }
}

