package de.jaggl.jetty.embedded.namespace;

import static org.springframework.beans.factory.support.BeanDefinitionBuilder.rootBeanDefinition;
import static org.springframework.beans.factory.support.BeanDefinitionReaderUtils.generateBeanName;
import static org.springframework.beans.factory.support.BeanDefinitionReaderUtils.registerBeanDefinition;
import static org.springframework.beans.factory.support.BeanDefinitionReaderUtils.registerWithGeneratedName;
import static org.springframework.util.ResourceUtils.getURL;
import static org.springframework.util.StringUtils.hasText;

import java.io.FileNotFoundException;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class JettyNamespaceHandler extends NamespaceHandlerSupport
{

    @Override
    public void init()
    {
        registerBeanDefinitionParser("embedded", new BeanDefinitionParser()
        {
            @Override
            public BeanDefinition parse(Element element,
                ParserContext parserContext)
            {
                String webAppContextId = registerWithGeneratedName(
                    rootBeanDefinition(WebAppContext.class)
                        .addConstructorArgValue(getWebAppPath(element))
                        .addConstructorArgValue(
                            element.getAttribute("contextPath"))
                        .addPropertyValue("parentLoaderPriority", Boolean.TRUE)
                        .getBeanDefinition(), parserContext.getRegistry());

                String defaultHandlerId = registerWithGeneratedName(
                    rootBeanDefinition(DefaultHandler.class)
                        .getBeanDefinition(), parserContext.getRegistry());

                String arrayId = registerWithGeneratedName(
                    rootBeanDefinition(HandlerHelper.class)
                        .addConstructorArgReference(webAppContextId)
                        .addConstructorArgReference(defaultHandlerId)
                        .setFactoryMethod("getArray")
                        .getBeanDefinition(),
                    parserContext.getRegistry());

                String handlerCollectionId = registerWithGeneratedName(
                    rootBeanDefinition(HandlerCollection.class)
                        .addConstructorArgValue(Boolean.TRUE)
                        .addPropertyReference("handlers", arrayId)
                        .getBeanDefinition(),
                    parserContext.getRegistry());

                AbstractBeanDefinition serverBeanDefinition = rootBeanDefinition(
                    Server.class)
                    .addConstructorArgValue(element.getAttribute("port"))
                    .addPropertyValue("stopAtShutdown", Boolean.TRUE)
                    .addPropertyReference("handler", handlerCollectionId)
                    .setInitMethodName("start")
                    .setDestroyMethodName("stop")
                    .getBeanDefinition();

                String id = element.getAttribute("id");
                if (!hasText(id))
                {
                    id = generateBeanName(serverBeanDefinition,
                        parserContext.getRegistry());
                }

                registerBeanDefinition(new BeanDefinitionHolder(
                    serverBeanDefinition, id), parserContext.getRegistry());

                return serverBeanDefinition;
            }

            private String getWebAppPath(Element element)
            {
                try
                {
                    return getURL(element.getAttribute("webAppPath"))
                        .toExternalForm();
                }
                catch (FileNotFoundException e)
                {
                    throw new RuntimeException(e);
                }
            }
        });
    }

}
