/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.jetty.embedded.namespace;

import de.jaggl.jetty.embedded.namespace.HandlerHelper;
import java.io.FileNotFoundException;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JettyNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("embedded", new BeanDefinitionParser(){

            public BeanDefinition parse(Element element, ParserContext parserContext) {
                String webAppContextId = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(WebAppContext.class).addConstructorArgValue((Object)this.getWebAppPath(element)).addConstructorArgValue((Object)element.getAttribute("contextPath")).addPropertyValue("parentLoaderPriority", (Object)Boolean.TRUE).getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
                String defaultHandlerId = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(DefaultHandler.class).getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
                String arrayId = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(HandlerHelper.class).addConstructorArgReference(webAppContextId).addConstructorArgReference(defaultHandlerId).setFactoryMethod("getArray").getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
                String handlerCollectionId = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(HandlerCollection.class).addConstructorArgValue((Object)Boolean.TRUE).addPropertyReference("handlers", arrayId).getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
                AbstractBeanDefinition serverBeanDefinition = BeanDefinitionBuilder.rootBeanDefinition(Server.class).addConstructorArgValue((Object)element.getAttribute("port")).addPropertyValue("stopAtShutdown", (Object)Boolean.TRUE).addPropertyReference("handler", handlerCollectionId).setInitMethodName("start").setDestroyMethodName("stop").getBeanDefinition();
                String id = element.getAttribute("id");
                if (!StringUtils.hasText((String)id)) {
                    id = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)serverBeanDefinition, (BeanDefinitionRegistry)parserContext.getRegistry());
                }
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)serverBeanDefinition, id), (BeanDefinitionRegistry)parserContext.getRegistry());
                return serverBeanDefinition;
            }

            private String getWebAppPath(Element element) {
                try {
                    return ResourceUtils.getURL((String)element.getAttribute("webAppPath")).toExternalForm();
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

