/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.jmx;

import de.jaggl.logging.jmx.domain.MBeanName;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;

public abstract class BroadcastingAppenderSkeleton
extends NotificationBroadcasterSupport
implements Appender,
OptionHandler {
    protected String name;
    protected String id = "default";
    protected Layout layout;
    protected Priority threshold;
    protected Filter headFilter;
    protected Filter tailFilter;
    protected ErrorHandler errorHandler;
    protected boolean closed = false;

    protected abstract void append(LoggingEvent var1);

    public void addFilter(Filter newFilter) {
        if (this.headFilter == null) {
            this.headFilter = newFilter;
            this.tailFilter = newFilter;
        } else {
            this.tailFilter.setNext(newFilter);
            this.tailFilter = newFilter;
        }
    }

    public Filter getFilter() {
        return this.headFilter;
    }

    public void clearFilters() {
        this.headFilter = null;
        this.tailFilter = null;
    }

    public void doAppend(LoggingEvent event) {
        if (!this.closed && this.isAsSevereAsThreshold((Priority)event.getLevel(), this.threshold) && this.filtersApply(event, this.headFilter)) {
            this.append(event);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        if (layout != null) {
            this.layout = layout;
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (!mbs.isRegistered(MBeanName.getObjectName(this.id))) {
                mbs.registerMBean(this, MBeanName.getObjectName(this.id));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void close() {
    }

    protected void finalize() throws Throwable {
        if (this.closed) {
            return;
        }
        this.close();
    }

    private boolean filtersApply(LoggingEvent event, Filter headFilter) {
        block5: while (headFilter != null) {
            switch (headFilter.decide(event)) {
                case -1: {
                    return false;
                }
                case 1: {
                    break block5;
                }
                case 0: {
                    headFilter = headFilter.getNext();
                }
                default: {
                    continue block5;
                }
            }
        }
        return true;
    }

    private boolean isAsSevereAsThreshold(Priority priority, Priority threshold) {
        return threshold == null || priority.isGreaterOrEqual(threshold);
    }

    public void setThreshold(Priority threshold) {
        this.threshold = threshold;
    }
}

