/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.jmx;

import de.jaggl.logging.jmx.BroadcastingAppenderSkeleton;
import de.jaggl.logging.jmx.JmxAppenderMBean;
import de.jaggl.utils.common.helpers.ListHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.Notification;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggingEvent;

public class JmxAppender
extends BroadcastingAppenderSkeleton
implements JmxAppenderMBean,
Serializable {
    private static final long serialVersionUID = 8216293743477900875L;
    private long sequenceNumber = 1L;
    private List<Notification> notificationQueue = new ArrayList<Notification>();
    private int numberLinesInMemory = 0;

    @Override
    protected void append(LoggingEvent event) {
        Notification notification = new Notification("JmxLogNotification", this, this.sequenceNumber++, event.getTimeStamp(), this.layout == null ? event.getMessage().toString() : this.layout.format(event));
        HashMap<String, String> userData = new HashMap<String, String>();
        userData.put("level", event.getLevel().toString());
        if (event.getThrowableStrRep() != null) {
            userData.put("trace", ListHelper.implodeArray((String)"\n", (Object[])event.getThrowableStrRep()));
        } else {
            userData.put("trace", "");
        }
        userData.put("thread", event.getThreadName());
        notification.setUserData(userData);
        this.sendNotification(notification);
        if (this.numberLinesInMemory > 0) {
            this.addToNotificationQueue(notification);
        }
    }

    @Override
    public void setRootLogLevel(String levelName) {
        LogManager.getRootLogger().setLevel(Level.toLevel((String)levelName.toUpperCase()));
    }

    @Override
    public void setJmxLogLevel(String levelName) {
        this.threshold = Level.toLevel((String)levelName);
    }

    @Override
    public String getRootLogLevel() {
        return LogManager.getRootLogger().getLevel().toString();
    }

    @Override
    public String getJmxLogLevel() {
        return this.threshold.toString();
    }

    @Override
    public List<Notification> getNotificationsInMemory() {
        return this.notificationQueue;
    }

    public void setNumberLinesInMemory(String numberLinesInMemory) {
        this.numberLinesInMemory = Integer.parseInt(numberLinesInMemory);
    }

    private void addToNotificationQueue(Notification notification) {
        this.notificationQueue.add(notification);
        if (this.notificationQueue.size() > this.numberLinesInMemory) {
            this.notificationQueue.remove(0);
        }
    }
}

