/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger;

import de.jaggl.logging.mslogger.domain.ConnectionUrl;
import de.jaggl.logging.mslogger.events.ConnectionEstablishedEvent;
import de.jaggl.logging.mslogger.events.NewConnectionEvent;
import de.jaggl.logging.mslogger.events.NotificationEvent;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConsoleLogger {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public ConsoleLogger() {
        SimpleEventQueue.subscribe((Object)this);
    }

    public static void main(String[] args) {
        ConnectionUrl connectionUrl;
        if (args.length == 0) {
            System.out.println("no connectionUrl given, exiting.");
            System.exit(0);
        }
        if ((connectionUrl = new ConnectionUrl(args[0])).getType() == null) {
            System.out.println("invalid connectionUrl given, exiting.");
            System.exit(0);
        }
        try {
            connectionUrl.getType().getNewConnectorInstance(1L);
            new ConsoleLogger();
            System.out.println("connecting to " + connectionUrl + "...");
            SimpleEventQueue.publish((Event)new NewConnectionEvent(connectionUrl));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Processing(value={ConnectionEstablishedEvent.class})
    private void process(ConnectionEstablishedEvent event) {
        System.out.println("connected to " + event.getConnectionUrl());
    }

    @Processing(value={NotificationEvent.class})
    private void process(NotificationEvent event) {
        System.out.println(this.dateFormat.format(new Date(event.getTimeStamp())) + " | " + event.getLevel() + " | " + event.getMessage());
    }
}

