/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.buttons;

import de.jaggl.logging.mslogger.components.buttons.CloseButton;
import de.jaggl.logging.mslogger.components.panels.LoggingTabbedPanel;
import de.jaggl.logging.mslogger.events.BringMainWindowToFrontEvent;
import de.jaggl.logging.mslogger.events.CloseTabEvent;
import de.jaggl.logging.mslogger.events.ConnectionClosedEvent;
import de.jaggl.logging.mslogger.events.ConnectionEstablishedEvent;
import de.jaggl.logging.mslogger.events.LanguageChangedEvent;
import de.jaggl.logging.mslogger.events.NotificationEvent;
import de.jaggl.logging.mslogger.events.TabSelectedEvent;
import de.jaggl.logging.mslogger.helpers.ColorHelper;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.logging.mslogger.helpers.SerialNumberHelper;
import de.jaggl.utils.events.actioncommand.annotations.ActionCommand;
import de.jaggl.utils.events.actioncommand.listeners.AnnotatedActionListener;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class ExtendedTabButton
extends JPanel {
    private static final long serialVersionUID = 3084472141281869025L;
    private final LoggingTabbedPanel tabbedPanel;
    private long id;
    private JLabel lowestLevelLabel;
    private Level lowestLevel = Level.WARN;

    public ExtendedTabButton(final LoggingTabbedPanel loggingTabbedPanel, long id) {
        super(new FlowLayout(1, 0, 0));
        this.id = id;
        if (loggingTabbedPanel == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.tabbedPanel = loggingTabbedPanel;
        this.setOpaque(false);
        JLabel label = new JLabel(){
            private static final long serialVersionUID = 6791420743957060592L;

            @Override
            public String getText() {
                int index = loggingTabbedPanel.indexOfTabComponent(ExtendedTabButton.this);
                if (index != -1) {
                    return loggingTabbedPanel.getTitleAt(index);
                }
                return null;
            }
        };
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.lowestLevelLabel = new JLabel();
        this.lowestLevelLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.lowestLevelLabel.setVisible(false);
        this.add(this.lowestLevelLabel);
        CloseTabButton closeTabButton = new CloseTabButton();
        closeTabButton.setActionCommand("close");
        closeTabButton.addActionListener((ActionListener)new AnnotatedActionListener((Object)this));
        this.add(closeTabButton);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        SimpleEventQueue.subscribe((Object)this);
    }

    @Processing(value={ConnectionEstablishedEvent.class})
    private void process(ConnectionEstablishedEvent event) {
        if (event.getId() == this.id) {
            int index = this.tabbedPanel.indexOfTabComponent(this);
            this.tabbedPanel.setTitleAt(index, event.getConnectionUrl().getPath());
            this.tabbedPanel.setBackgroundAt(index, ColorHelper.CONNECTED);
            this.tabbedPanel.updateUI();
        }
    }

    @Processing(value={ConnectionClosedEvent.class})
    private void process(ConnectionClosedEvent event) {
        int index;
        if (event.getId() == this.id && (index = this.tabbedPanel.indexOfTabComponent(this)) != -1) {
            this.tabbedPanel.setTitleAt(index, LanguageHelper.getText("loggingPanel.notConnected"));
            this.tabbedPanel.setBackgroundAt(index, ColorHelper.DISCONNECTED);
            this.tabbedPanel.updateUI();
        }
    }

    @Processing(value={NotificationEvent.class})
    private void process(NotificationEvent event) {
        if (event.getId() == this.id && SerialNumberHelper.hasValidatedSerialNumber()) {
            Level level = event.getLevel();
            if (level.isGreaterOrEqual((Priority)this.lowestLevel)) {
                this.lowestLevel = level;
                this.lowestLevelLabel.setForeground(ColorHelper.getColor(level));
                this.lowestLevelLabel.setText("[" + level + "]");
                this.lowestLevelLabel.setVisible(true);
            }
            if (level.isGreaterOrEqual((Priority)Level.WARN)) {
                SimpleEventQueue.publish((Event)new BringMainWindowToFrontEvent());
            }
        }
    }

    @Processing(value={TabSelectedEvent.class})
    private void process(TabSelectedEvent event) {
        if (event.getId() == this.id) {
            this.lowestLevelLabel.setVisible(false);
            this.lowestLevel = Level.WARN;
        }
    }

    @Processing(value={CloseTabEvent.class})
    private void process(CloseTabEvent event) {
        if (event.getId() == this.id) {
            SimpleEventQueue.unsubscribe((Object)this);
        }
    }

    @Processing(value={LanguageChangedEvent.class})
    private void onLanguageChanged() {
        int index = this.tabbedPanel.indexOfTabComponent(this);
        if (this.tabbedPanel.getBackgroundAt(index).equals(ColorHelper.DISCONNECTED)) {
            this.tabbedPanel.setTitleAt(index, LanguageHelper.getText("loggingPanel.notConnected"));
            this.tabbedPanel.updateUI();
        }
    }

    @ActionCommand(value={"close"})
    private void onClose() {
        int index = this.tabbedPanel.indexOfTabComponent(this);
        if (index != -1) {
            SimpleEventQueue.publish((Event)new CloseTabEvent(this.id));
        }
    }

    private class CloseTabButton
    extends CloseButton {
        private static final long serialVersionUID = 7140669047495257476L;

        private CloseTabButton() {
        }

        @Override
        public void updateUI() {
            ExtendedTabButton.this.tabbedPanel.repaint();
        }
    }
}

