/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.frames;

import de.jaggl.logging.jmx.JmxAppenderMBean;
import de.jaggl.logging.mslogger.components.comboboxes.SelectLogLevelComboBox;
import de.jaggl.logging.mslogger.connectors.JmxConnector;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.utils.common.helpers.swing.SpringLayoutHelper;
import de.jaggl.utils.common.helpers.swing.WindowHelper;
import de.jaggl.utils.events.actioncommand.annotations.ActionCommand;
import de.jaggl.utils.events.actioncommand.listeners.AnnotatedActionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.apache.log4j.Level;

public class JmxConnectionSettingsWindow
extends JDialog {
    private static final long serialVersionUID = -1960583442804811446L;
    private JmxAppenderMBean jmxAppender;
    private SelectLogLevelComboBox rootLoggerLevelComboBox;
    private SelectLogLevelComboBox jmxAppenderLevelComboBox;

    public JmxConnectionSettingsWindow(JmxConnector jmxConnector) {
        this.jmxAppender = jmxConnector.getJmxAppender();
        this.setTitle(LanguageHelper.getText("connectionSettings.jmx.title"));
        this.setModal(true);
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(LanguageHelper.getText("connectionSettings.jmx.rootLoggerLevel")));
        this.rootLoggerLevelComboBox = new SelectLogLevelComboBox();
        this.rootLoggerLevelComboBox.setSelectedLevel(Level.toLevel((String)this.jmxAppender.getRootLogLevel()));
        panel.add(this.rootLoggerLevelComboBox);
        panel.add(new JLabel(LanguageHelper.getText("connectionSettings.jmx.jmxAppenderLevel")));
        this.jmxAppenderLevelComboBox = new SelectLogLevelComboBox();
        this.jmxAppenderLevelComboBox.setSelectedLevel(Level.toLevel((String)this.jmxAppender.getJmxLogLevel()));
        panel.add(this.jmxAppenderLevelComboBox);
        SpringLayoutHelper.makeCompactGrid((Container)panel, (int)2, (int)2, (int)6, (int)6, (int)6, (int)6);
        this.add((Component)panel, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JButton okButton = new JButton(LanguageHelper.getText("connectionSettings.ok"));
        okButton.setActionCommand("okClicked");
        okButton.addActionListener((ActionListener)new AnnotatedActionListener((Object)this));
        bottomPanel.add((Component)okButton, "After");
        this.add((Component)bottomPanel, "Last");
        this.setAlwaysOnTop(true);
        this.pack();
        WindowHelper.closeOnExcape((JDialog)this);
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(null);
    }

    @ActionCommand(value={"okClicked"})
    private void onOk() {
        this.jmxAppender.setRootLogLevel(this.rootLoggerLevelComboBox.getSelectedLevel().toString());
        this.jmxAppender.setJmxLogLevel(this.jmxAppenderLevelComboBox.getSelectedLevel().toString());
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

