/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.frames;

import de.jaggl.logging.mslogger.events.NotificationEvent;
import de.jaggl.logging.mslogger.helpers.ColorHelper;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.utils.common.helpers.swing.SpringLayoutHelper;
import de.jaggl.utils.common.helpers.swing.WindowHelper;
import java.awt.Container;
import java.text.SimpleDateFormat;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import org.apache.log4j.Level;

public class LogDetailsWindow
extends JDialog {
    private static final long serialVersionUID = 996166536340122455L;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss,SSS");

    public LogDetailsWindow(NotificationEvent notificationEvent) {
        this.setTitle(LanguageHelper.getText("logDetails.title"));
        this.setModal(true);
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(LanguageHelper.getText("logDetails.dateTime")));
        panel.add(new JLabel(this.dateFormat.format(notificationEvent.getTimeStamp())));
        panel.add(new JLabel(LanguageHelper.getText("logDetails.level")));
        String level = notificationEvent.getLevel().toString();
        JLabel levelLabel = new JLabel(level);
        levelLabel.setForeground(ColorHelper.getColor(Level.toLevel((String)level)));
        panel.add(levelLabel);
        panel.add(new JLabel(LanguageHelper.getText("logDetails.message")));
        JTextArea messageArea = new JTextArea(3, 60);
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        messageArea.setText(notificationEvent.getMessage());
        messageArea.setEditable(false);
        messageArea.setCaretPosition(0);
        JScrollPane messageScrollPane = new JScrollPane(messageArea);
        panel.add(messageScrollPane);
        String trace = notificationEvent.getTrace();
        int numberRows = 6;
        if (trace != null && !trace.isEmpty()) {
            panel.add(new JLabel(LanguageHelper.getText("logDetails.trace")));
            JTextArea stackArea = new JTextArea(30, 60);
            stackArea.setText(trace);
            stackArea.setEditable(false);
            stackArea.setCaretPosition(0);
            JScrollPane stackScrollPane = new JScrollPane(stackArea);
            panel.add(stackScrollPane);
            ++numberRows;
        }
        panel.add(new JLabel(LanguageHelper.getText("logDetails.type")));
        panel.add(new JLabel(notificationEvent.getType()));
        panel.add(new JLabel(LanguageHelper.getText("logDetails.source")));
        panel.add(new JLabel(notificationEvent.getSource().toString()));
        if (notificationEvent.getThread() != null) {
            panel.add(new JLabel(LanguageHelper.getText("logDetails.thread")));
            panel.add(new JLabel(notificationEvent.getThread()));
            ++numberRows;
        }
        panel.add(new JLabel(LanguageHelper.getText("logDetails.sequenceNumber")));
        panel.add(new JLabel(String.valueOf(notificationEvent.getSequenceNumber())));
        SpringLayoutHelper.makeCompactGrid((Container)panel, (int)numberRows, (int)2, (int)6, (int)6, (int)6, (int)6);
        this.add(panel);
        this.setAlwaysOnTop(true);
        this.pack();
        WindowHelper.closeOnExcape((JDialog)this);
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(null);
    }
}

