/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.frames;

import de.jaggl.logging.mslogger.MSLogger;
import de.jaggl.logging.mslogger.components.menus.MainMenu;
import de.jaggl.logging.mslogger.components.panels.FavoritesPanel;
import de.jaggl.logging.mslogger.components.panels.LoggingTabbedPanel;
import de.jaggl.logging.mslogger.events.BringMainWindowToFrontEvent;
import de.jaggl.logging.mslogger.events.ChangedAlwaysOnTopEvent;
import de.jaggl.logging.mslogger.events.FavoritesVisibilityChangedEvent;
import de.jaggl.logging.mslogger.events.NewTabEvent;
import de.jaggl.logging.mslogger.events.ToggleFavoritesVisibilityEvent;
import de.jaggl.logging.mslogger.helpers.AppleHelper;
import de.jaggl.logging.mslogger.helpers.MavenHelper;
import de.jaggl.logging.mslogger.helpers.PreferencesHelper;
import de.jaggl.logging.mslogger.helpers.SerialNumberHelper;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 6490853374412030740L;
    private FavoritesPanel favoritesPanel;
    private LoggingTabbedPanel tabbedPane;
    private JSplitPane splitPane;

    public MainWindow() {
        String version = MavenHelper.getVersionFromManifest(MSLogger.class);
        this.setTitle("MSLogger " + (version != null ? version + " " : "") + "\u00a9 www.martin-schumacher.com");
        if (SerialNumberHelper.hasValidatedSerialNumber() && PreferencesHelper.pref("stayOnTop", true)) {
            this.setAlwaysOnTop(true);
        }
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        AppleHelper.setFullscreen(this);
        this.setJMenuBar(new MainMenu());
        this.favoritesPanel = new FavoritesPanel();
        this.favoritesPanel.setVisible(false);
        this.tabbedPane = new LoggingTabbedPanel();
        this.splitPane = new JSplitPane(1, this.favoritesPanel, this.tabbedPane);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setDividerSize(0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (MainWindow.this.splitPane.getDividerLocation() > 2) {
                    PreferencesHelper.setPref("mainWindowDividerPosition", MainWindow.this.splitPane.getDividerLocation());
                }
            }
        });
        this.add((Component)this.splitPane, "Center");
        this.pack();
        this.setMinimumSize(new Dimension(1003, 300));
        this.setSize(new Dimension(PreferencesHelper.pref("mainWindowWidth", 1010), PreferencesHelper.pref("mainWindowHeight", 400)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screenSize.width - this.getWidth();
        int y = screenSize.height - this.getHeight();
        this.setLocation(PreferencesHelper.pref("mainWindowLeft", x), PreferencesHelper.pref("mainWindowTop", y));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent event) {
                PreferencesHelper.setPref("mainWindowLeft", MainWindow.this.getLocation().x);
                PreferencesHelper.setPref("mainWindowTop", MainWindow.this.getLocation().y);
            }

            @Override
            public void componentResized(ComponentEvent event) {
                PreferencesHelper.setPref("mainWindowWidth", MainWindow.this.getSize().width);
                PreferencesHelper.setPref("mainWindowHeight", MainWindow.this.getSize().height);
            }
        });
        SimpleEventQueue.subscribe((Object)this);
        if (PreferencesHelper.pref("favoritesVisible", false)) {
            SimpleEventQueue.publish((Event)new ToggleFavoritesVisibilityEvent());
        }
        SimpleEventQueue.publish((Event)new NewTabEvent());
    }

    @Processing(value={FavoritesVisibilityChangedEvent.class})
    private void process(FavoritesVisibilityChangedEvent event) {
        if (event.getVisibility()) {
            this.splitPane.setDividerSize(3);
            this.splitPane.setDividerLocation(PreferencesHelper.pref("mainWindowDividerPosition", 200));
        } else {
            this.splitPane.setDividerSize(0);
            this.splitPane.setDividerLocation(0);
        }
    }

    @Processing(value={ChangedAlwaysOnTopEvent.class})
    private void process(ChangedAlwaysOnTopEvent event) {
        this.setAlwaysOnTop(event.getAlwaysOnTop());
    }

    @Processing(value={BringMainWindowToFrontEvent.class})
    private void onBringMainWindowToFront() {
        if (SerialNumberHelper.hasValidatedSerialNumber() && PreferencesHelper.pref("bringToFront", true) && !this.isAlwaysOnTop()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWindow.this.toFront();
                    MainWindow.this.repaint();
                }
            });
        }
    }
}

