/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.frames;

import de.jaggl.logging.mslogger.domain.ConnectionUrl;
import de.jaggl.logging.mslogger.events.ErrorEvent;
import de.jaggl.logging.mslogger.events.NewConnectionEvent;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.utils.common.helpers.swing.SpringLayoutHelper;
import de.jaggl.utils.common.helpers.swing.WindowHelper;
import de.jaggl.utils.events.actioncommand.annotations.ActionCommand;
import de.jaggl.utils.events.actioncommand.listeners.AnnotatedActionListener;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.domain.Event;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class NewConnectionWindow
extends JDialog {
    private static final long serialVersionUID = 8502590074596762404L;
    private ActionListener actionListener;
    private JButton connectButton;
    private JTabbedPane tabbedPane;
    private JLabel jmxHostLabel;
    private JLabel jmxPortLabel;
    private JLabel jmxIdLabel;
    private JTextField jmxHostTextField;
    private JTextField jmxPortTextField;
    private JTextField jmxIdTextField;
    private JLabel jmsHostLabel;
    private JLabel jmsPortLabel;
    private JLabel jmsIdLabel;
    private JTextField jmsHostTextField;
    private JTextField jmsPortTextField;
    private JTextField jmsIdTextField;

    public NewConnectionWindow() {
        this.setTitle(LanguageHelper.getText("newConnection.title"));
        this.actionListener = new AnnotatedActionListener((Object)this);
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("JMX", this.getJmxConnectionPane());
        this.tabbedPane.addTab("JMS", this.getJmsConnectionPane());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.getBottomPane(), "Last");
        this.pack();
        WindowHelper.closeOnExcape((JDialog)this);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private JPanel getBottomPane() {
        JPanel bottomPane = new JPanel(new BorderLayout());
        this.connectButton = new JButton(LanguageHelper.getText("newConnection.connect"));
        this.connectButton.setActionCommand("okClicked");
        this.connectButton.addActionListener(this.actionListener);
        bottomPane.add((Component)this.connectButton, "After");
        return bottomPane;
    }

    private JPanel getJmxConnectionPane() {
        JPanel jmxConnectionPane = new JPanel(new SpringLayout());
        jmxConnectionPane.setOpaque(false);
        this.jmxHostLabel = new JLabel(LanguageHelper.getText("newConnection.jmx.host"));
        this.jmxPortLabel = new JLabel(LanguageHelper.getText("newConnection.jmx.port"));
        this.jmxIdLabel = new JLabel(LanguageHelper.getText("newConnection.jmx.id"));
        this.jmxHostTextField = new JTextField(20);
        this.jmxPortTextField = new JTextField();
        this.jmxIdTextField = new JTextField();
        this.jmxHostTextField.setActionCommand("enterPressed");
        this.jmxHostTextField.addActionListener(this.actionListener);
        this.jmxPortTextField.setActionCommand("enterPressed");
        this.jmxPortTextField.addActionListener(this.actionListener);
        this.jmxIdTextField.setActionCommand("enterPressed");
        this.jmxIdTextField.addActionListener(this.actionListener);
        jmxConnectionPane.add(this.jmxHostLabel);
        jmxConnectionPane.add(this.jmxHostTextField);
        jmxConnectionPane.add(this.jmxPortLabel);
        jmxConnectionPane.add(this.jmxPortTextField);
        jmxConnectionPane.add(this.jmxIdLabel);
        jmxConnectionPane.add(this.jmxIdTextField);
        SpringLayoutHelper.makeCompactGrid((Container)jmxConnectionPane, (int)3, (int)2, (int)6, (int)6, (int)6, (int)6);
        return jmxConnectionPane;
    }

    private JPanel getJmsConnectionPane() {
        JPanel jmsConnectionPane = new JPanel(new SpringLayout());
        jmsConnectionPane.setOpaque(false);
        this.jmsHostLabel = new JLabel(LanguageHelper.getText("newConnection.jms.host"));
        this.jmsPortLabel = new JLabel(LanguageHelper.getText("newConnection.jms.port"));
        this.jmsIdLabel = new JLabel(LanguageHelper.getText("newConnection.jms.id"));
        this.jmsHostTextField = new JTextField(20);
        this.jmsPortTextField = new JTextField();
        this.jmsIdTextField = new JTextField();
        this.jmsHostTextField.setActionCommand("enterPressed");
        this.jmsHostTextField.addActionListener(this.actionListener);
        this.jmsPortTextField.setActionCommand("enterPressed");
        this.jmsPortTextField.addActionListener(this.actionListener);
        this.jmsIdTextField.setActionCommand("enterPressed");
        this.jmsIdTextField.addActionListener(this.actionListener);
        jmsConnectionPane.add(this.jmsHostLabel);
        jmsConnectionPane.add(this.jmsHostTextField);
        jmsConnectionPane.add(this.jmsPortLabel);
        jmsConnectionPane.add(this.jmsPortTextField);
        jmsConnectionPane.add(this.jmsIdLabel);
        jmsConnectionPane.add(this.jmsIdTextField);
        SpringLayoutHelper.makeCompactGrid((Container)jmsConnectionPane, (int)3, (int)2, (int)6, (int)6, (int)6, (int)6);
        return jmsConnectionPane;
    }

    @ActionCommand(value={"okClicked", "enterPressed"})
    private void onOk() {
        String connectionPath = null;
        if (this.tabbedPane.getSelectedIndex() == 0) {
            connectionPath = "jmx://" + this.jmxHostTextField.getText() + ":" + this.jmxPortTextField.getText() + "/" + this.jmxIdTextField.getText();
        } else if (this.tabbedPane.getSelectedIndex() == 1) {
            connectionPath = "jms://" + this.jmsHostTextField.getText() + ":" + this.jmsPortTextField.getText() + "/" + this.jmsIdTextField.getText();
        }
        ConnectionUrl connectionUrl = new ConnectionUrl(connectionPath.trim());
        if (connectionUrl.getType() == null) {
            SimpleEventQueue.publish((Event)new ErrorEvent(ErrorEvent.ErrorCode.INVALID_CONNECTION_URL_GIVEN, connectionPath.trim()));
        } else {
            SimpleEventQueue.publish((Event)new NewConnectionEvent(connectionUrl));
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }
}

