/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.frames;

import de.jaggl.logging.mslogger.events.ChangeLanguageEvent;
import de.jaggl.logging.mslogger.events.ChangedAlwaysOnTopEvent;
import de.jaggl.logging.mslogger.events.ChangedMaxShownLinesEvent;
import de.jaggl.logging.mslogger.events.ErrorEvent;
import de.jaggl.logging.mslogger.events.ValidSerialNumberGivenEvent;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.logging.mslogger.helpers.PreferencesHelper;
import de.jaggl.logging.mslogger.helpers.SerialNumberHelper;
import de.jaggl.utils.common.helpers.swing.SpringLayoutHelper;
import de.jaggl.utils.common.helpers.swing.WindowHelper;
import de.jaggl.utils.events.actioncommand.annotations.ActionCommand;
import de.jaggl.utils.events.actioncommand.listeners.AnnotatedActionListener;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.domain.Event;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.omg.CORBA.UnknownUserException;

public class PreferencesWindow
extends JDialog {
    private static final long serialVersionUID = -5202914441172605480L;
    private JTextField maxShownLinesTextField;
    private JTextField serialNumberTextField;
    private JCheckBox connectToAllFavoritesCheckBox;
    private JCheckBox stayOnTopCheckBox;
    private JComboBox<String> languageComboBox;
    private JCheckBox bringToFrontCheckBox;

    public PreferencesWindow() {
        this.setTitle(LanguageHelper.getText("settings.title"));
        this.setModal(true);
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(LanguageHelper.getText("settings.language")));
        this.languageComboBox = new JComboBox<String>(LanguageHelper.getAvailableLanguages().toArray(new String[0]));
        for (int i = 0; i < this.languageComboBox.getItemCount(); ++i) {
            if (!this.languageComboBox.getItemAt(i).equals(LanguageHelper.getCurrentLanguage())) continue;
            this.languageComboBox.setSelectedIndex(i);
        }
        panel.add(this.languageComboBox);
        JLabel connectToAllFavoritesOnStartupLabel = new JLabel(LanguageHelper.getText("settings.connectToAllFavoritesOnStartup"));
        panel.add(connectToAllFavoritesOnStartupLabel);
        this.connectToAllFavoritesCheckBox = new JCheckBox("", PreferencesHelper.pref("connectToAllFavorites", false));
        panel.add(this.connectToAllFavoritesCheckBox);
        JLabel maxShownLinesLabel = new JLabel(LanguageHelper.getText("settings.maxShownLines"));
        panel.add(maxShownLinesLabel);
        this.maxShownLinesTextField = new JTextField(String.valueOf(PreferencesHelper.pref("maxShownLines", 1000)), 5);
        panel.add(this.maxShownLinesTextField);
        JLabel holdWindowInForegroundLabel = new JLabel(LanguageHelper.getText("settings.holdWindowInForeground"));
        panel.add(holdWindowInForegroundLabel);
        this.stayOnTopCheckBox = new JCheckBox("", PreferencesHelper.pref("stayOnTop", true));
        panel.add(this.stayOnTopCheckBox);
        JLabel setToForegroundOnCriticalMessageLabel = new JLabel(LanguageHelper.getText("settings.setToForegroundOnCriticalMessage"));
        panel.add(setToForegroundOnCriticalMessageLabel);
        this.bringToFrontCheckBox = new JCheckBox("", PreferencesHelper.pref("bringToFront", true));
        panel.add(this.bringToFrontCheckBox);
        JLabel serialNumberLabel = new JLabel(LanguageHelper.getText("settings.serialNumber"));
        panel.add(serialNumberLabel);
        this.serialNumberTextField = new JTextField(PreferencesHelper.pref("serialNumber", ""), 24);
        panel.add(this.serialNumberTextField);
        if (SerialNumberHelper.validateSerialnumber(this.serialNumberTextField.getText())) {
            serialNumberLabel.setEnabled(false);
            this.serialNumberTextField.setEnabled(false);
        }
        SpringLayoutHelper.makeCompactGrid((Container)panel, (int)6, (int)2, (int)6, (int)6, (int)6, (int)6);
        this.add((Component)panel, "Center");
        if (!SerialNumberHelper.hasValidatedSerialNumber()) {
            connectToAllFavoritesOnStartupLabel.setEnabled(false);
            connectToAllFavoritesOnStartupLabel.setText(connectToAllFavoritesOnStartupLabel.getText() + " (PRO)");
            this.connectToAllFavoritesCheckBox.setEnabled(false);
            this.connectToAllFavoritesCheckBox.setSelected(false);
            maxShownLinesLabel.setEnabled(false);
            maxShownLinesLabel.setText(maxShownLinesLabel.getText() + " (PRO)");
            this.maxShownLinesTextField.setEnabled(false);
            this.maxShownLinesTextField.setText("100");
            holdWindowInForegroundLabel.setEnabled(false);
            holdWindowInForegroundLabel.setText(holdWindowInForegroundLabel.getText() + " (PRO)");
            this.stayOnTopCheckBox.setEnabled(false);
            this.stayOnTopCheckBox.setSelected(false);
            setToForegroundOnCriticalMessageLabel.setEnabled(false);
            setToForegroundOnCriticalMessageLabel.setText(setToForegroundOnCriticalMessageLabel.getText() + " (PRO)");
            this.bringToFrontCheckBox.setEnabled(false);
            this.bringToFrontCheckBox.setSelected(false);
        }
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JButton okButton = new JButton(LanguageHelper.getText("settings.ok"));
        okButton.setActionCommand("okClicked");
        okButton.addActionListener((ActionListener)new AnnotatedActionListener((Object)this));
        bottomPanel.add((Component)okButton, "After");
        this.add((Component)bottomPanel, "Last");
        this.setAlwaysOnTop(true);
        this.pack();
        WindowHelper.closeOnExcape((JDialog)this);
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(null);
    }

    @ActionCommand(value={"okClicked"})
    private void onOkClicked() {
        try {
            int maxShownLines = Integer.parseInt(this.maxShownLinesTextField.getText().trim());
            if (maxShownLines > 100000) {
                throw new IllegalArgumentException();
            }
            if (!this.serialNumberTextField.getText().trim().isEmpty()) {
                if (SerialNumberHelper.validateSerialnumber(this.serialNumberTextField.getText())) {
                    SerialNumberHelper.setHasValidatedSerialNumber(true);
                    PreferencesHelper.setPref("serialNumber", this.serialNumberTextField.getText());
                } else {
                    throw new UnknownUserException();
                }
            }
            PreferencesHelper.setPref("connectToAllFavorites", this.connectToAllFavoritesCheckBox.isSelected());
            PreferencesHelper.setPref("maxShownLines", maxShownLines);
            SimpleEventQueue.publish((Event)new ChangedMaxShownLinesEvent(maxShownLines));
            PreferencesHelper.setPref("stayOnTop", this.stayOnTopCheckBox.isSelected());
            SimpleEventQueue.publish((Event)new ChangedAlwaysOnTopEvent(this.stayOnTopCheckBox.isSelected()));
            SimpleEventQueue.publish((Event)new ChangeLanguageEvent((String)this.languageComboBox.getSelectedItem()));
            SimpleEventQueue.publish((Event)new ValidSerialNumberGivenEvent());
            PreferencesHelper.setPref("bringToFront", this.bringToFrontCheckBox.isSelected());
            this.dispatchEvent(new WindowEvent(this, 201));
        }
        catch (NumberFormatException e) {
            SimpleEventQueue.publish((Event)new ErrorEvent(ErrorEvent.ErrorCode.INVALID_MAX_SHOWN_LINES_GIVEN, this.maxShownLinesTextField.getText().trim()));
        }
        catch (IllegalArgumentException e) {
            SimpleEventQueue.publish((Event)new ErrorEvent(ErrorEvent.ErrorCode.TOO_BIG_MAX_SHOWN_LINES_GIVEN, new Object[0]));
        }
        catch (UnknownUserException e) {
            SimpleEventQueue.publish((Event)new ErrorEvent(ErrorEvent.ErrorCode.INVALID_SERIALNUMBER_GIVEN, new Object[0]));
        }
    }
}

