/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.menus;

import de.jaggl.logging.mslogger.events.AddCurrentTabToFavoritesEvent;
import de.jaggl.logging.mslogger.events.ClearCurrentLoggingTableEvent;
import de.jaggl.logging.mslogger.events.CloseCurrentTabEvent;
import de.jaggl.logging.mslogger.events.ConnectAllFavoritesEvent;
import de.jaggl.logging.mslogger.events.FavoritesVisibilityChangedEvent;
import de.jaggl.logging.mslogger.events.LanguageChangedEvent;
import de.jaggl.logging.mslogger.events.NewTabEvent;
import de.jaggl.logging.mslogger.events.ShowCurrentConnectionSettingsEvent;
import de.jaggl.logging.mslogger.events.ShowPreferencesEvent;
import de.jaggl.logging.mslogger.events.SwitchTabEvent;
import de.jaggl.logging.mslogger.events.ToggleFavoritesVisibilityEvent;
import de.jaggl.logging.mslogger.events.ValidSerialNumberGivenEvent;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.logging.mslogger.helpers.SerialNumberHelper;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MainMenu
extends JMenuBar {
    private static final long serialVersionUID = 3453051991240109767L;
    private JMenu optionMenu = new JMenu(LanguageHelper.getText("mainmenu.items.options"));
    private JMenuItem newTabMenuItem = this.addMenuItem(this.optionMenu, "mainmenu.items.options.newTab", new NewTabEvent(), KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    private JMenuItem closeTabMenuItem = this.addMenuItem(this.optionMenu, "mainmenu.items.options.closeTab", new CloseCurrentTabEvent(), KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    private JMenuItem nextTabMenuItem = this.addMenuItem(this.optionMenu, "mainmenu.items.options.nextTab", new SwitchTabEvent(SwitchTabEvent.Direction.FORWARD), KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 512));
    private JMenuItem previousTabMenuItem = this.addMenuItem(this.optionMenu, "mainmenu.items.options.previousTab", new SwitchTabEvent(SwitchTabEvent.Direction.BACKWARD), KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 512));
    private JMenuItem clearCurrentListMenuItem;
    private JMenuItem toggleFavoritesVisibilityMenuItem;
    private JMenuItem addToFavoritesMenuItem;
    private JMenuItem connectAllFavoritesMenuItem;
    private JMenuItem settingsMenuItem;
    private JMenuItem connectionSettingsMenuItem;
    private boolean favoritesVisible = false;

    public MainMenu() {
        this.optionMenu.addSeparator();
        this.clearCurrentListMenuItem = this.addMenuItem(this.optionMenu, "mainmenu.items.options.clearCurrentList", new ClearCurrentLoggingTableEvent(), KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.optionMenu.addSeparator();
        this.toggleFavoritesVisibilityMenuItem = this.addMenuItem(this.optionMenu, "mainmenu.items.options.showFavorites", new ToggleFavoritesVisibilityEvent(), KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.addToFavoritesMenuItem = this.addMenuItem(this.optionMenu, "mainmenu.items.options.addToFavorites", new AddCurrentTabToFavoritesEvent(), KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 64));
        this.connectAllFavoritesMenuItem = this.addMenuItem(this.optionMenu, "mainmenu.items.options.connectAllFavorites", new ConnectAllFavoritesEvent(), KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 64));
        this.optionMenu.addSeparator();
        this.settingsMenuItem = this.addMenuItem(this.optionMenu, "mainmenu.items.options.settings", new ShowPreferencesEvent(), KeyStroke.getKeyStroke(44, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.connectionSettingsMenuItem = this.addMenuItem(this.optionMenu, "mainmenu.items.options.connectionSettings", new ShowCurrentConnectionSettingsEvent(), KeyStroke.getKeyStroke(44, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 64));
        this.add(this.optionMenu);
        if (!SerialNumberHelper.hasValidatedSerialNumber()) {
            this.newTabMenuItem.setEnabled(false);
            this.newTabMenuItem.setText(this.newTabMenuItem.getText() + " (PRO)");
            this.closeTabMenuItem.setEnabled(false);
            this.closeTabMenuItem.setText(this.closeTabMenuItem.getText() + " (PRO)");
            this.nextTabMenuItem.setEnabled(false);
            this.nextTabMenuItem.setText(this.nextTabMenuItem.getText() + " (PRO)");
            this.previousTabMenuItem.setEnabled(false);
            this.previousTabMenuItem.setText(this.previousTabMenuItem.getText() + " (PRO)");
            this.toggleFavoritesVisibilityMenuItem.setEnabled(false);
            this.toggleFavoritesVisibilityMenuItem.setText(this.toggleFavoritesVisibilityMenuItem.getText() + " (PRO)");
            this.addToFavoritesMenuItem.setEnabled(false);
            this.addToFavoritesMenuItem.setText(this.addToFavoritesMenuItem.getText() + " (PRO)");
            this.connectAllFavoritesMenuItem.setEnabled(false);
            this.connectAllFavoritesMenuItem.setText(this.connectAllFavoritesMenuItem.getText() + " (PRO)");
            this.connectionSettingsMenuItem.setEnabled(false);
            this.connectionSettingsMenuItem.setText(this.connectionSettingsMenuItem.getText() + " (PRO)");
        }
        SimpleEventQueue.subscribe((Object)this);
    }

    @Processing(value={FavoritesVisibilityChangedEvent.class})
    private void process(FavoritesVisibilityChangedEvent event) {
        this.favoritesVisible = event.getVisibility();
        this.toggleFavoritesVisibilityMenuItem.setText(event.getVisibility() ? LanguageHelper.getText("mainmenu.items.options.hideFavorites") : LanguageHelper.getText("mainmenu.items.options.showFavorites"));
    }

    @Processing(value={ValidSerialNumberGivenEvent.class})
    private void onValidSerialNumberGiven() {
        this.newTabMenuItem.setEnabled(true);
        this.newTabMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.newTab"));
        this.closeTabMenuItem.setEnabled(true);
        this.closeTabMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.closeTab"));
        this.nextTabMenuItem.setEnabled(true);
        this.nextTabMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.nextTab"));
        this.previousTabMenuItem.setEnabled(true);
        this.previousTabMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.previousTab"));
        this.toggleFavoritesVisibilityMenuItem.setEnabled(true);
        this.toggleFavoritesVisibilityMenuItem.setText(LanguageHelper.getText(this.favoritesVisible ? "mainmenu.items.options.hideFavorites" : "mainmenu.items.options.showFavorites"));
        this.addToFavoritesMenuItem.setEnabled(true);
        this.addToFavoritesMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.addToFavorites"));
        this.connectAllFavoritesMenuItem.setEnabled(true);
        this.connectAllFavoritesMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.connectAllFavorites"));
        this.connectionSettingsMenuItem.setEnabled(true);
        this.connectionSettingsMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.connectionSettings"));
    }

    @Processing(value={LanguageChangedEvent.class})
    private void onLanguageChanged() {
        this.optionMenu.setText(LanguageHelper.getText("mainmenu.items.options"));
        this.newTabMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.newTab"));
        this.closeTabMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.closeTab"));
        this.nextTabMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.nextTab"));
        this.previousTabMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.previousTab"));
        this.clearCurrentListMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.clearCurrentList"));
        this.toggleFavoritesVisibilityMenuItem.setText(LanguageHelper.getText(this.favoritesVisible ? "mainmenu.items.options.hideFavorites" : "mainmenu.items.options.showFavorites"));
        this.addToFavoritesMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.addToFavorites"));
        this.connectAllFavoritesMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.connectAllFavorites"));
        this.settingsMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.settings"));
        this.connectionSettingsMenuItem.setText(LanguageHelper.getText("mainmenu.items.options.connectionSettings"));
    }

    private JMenuItem addMenuItem(JMenu menu, String titleKey, final Event event, KeyStroke keyStroke) {
        JMenuItem menuItem = new JMenuItem(LanguageHelper.getText(titleKey));
        if (keyStroke != null) {
            menuItem.setAccelerator(keyStroke);
        }
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleEventQueue.publish((Event)event);
            }
        });
        menu.add(menuItem);
        return menuItem;
    }
}

