/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.panels;

import de.jaggl.logging.mslogger.domain.ConnectionUrl;
import de.jaggl.logging.mslogger.events.CloseConnectionEvent;
import de.jaggl.logging.mslogger.events.CloseTabEvent;
import de.jaggl.logging.mslogger.events.ConnectionClosedEvent;
import de.jaggl.logging.mslogger.events.ConnectionEstablishedEvent;
import de.jaggl.logging.mslogger.events.ErrorEvent;
import de.jaggl.logging.mslogger.events.LanguageChangedEvent;
import de.jaggl.logging.mslogger.events.NewConnectionForIdEvent;
import de.jaggl.logging.mslogger.events.ShowNewConnectionEvent;
import de.jaggl.logging.mslogger.events.ValidSerialNumberGivenEvent;
import de.jaggl.logging.mslogger.helpers.ColorHelper;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.logging.mslogger.helpers.SerialNumberHelper;
import de.jaggl.utils.events.actioncommand.annotations.ActionCommand;
import de.jaggl.utils.events.actioncommand.listeners.AnnotatedActionListener;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConnectionPanel
extends JPanel {
    private static final long serialVersionUID = -6112812441819393257L;
    private JTextField connectionTextField;
    private JButton newConnectionButton;
    private JButton connectButton;
    private JLabel connectionLabel;
    private boolean connected = false;
    private ConnectionUrl connectionUrl;
    private long id;

    public ConnectionPanel(long id) {
        this.id = id;
        AnnotatedActionListener actionListener = new AnnotatedActionListener((Object)this);
        this.setBackground(ColorHelper.DISCONNECTED);
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.connectionLabel = new JLabel(LanguageHelper.getText("loggingPanel.connection"));
        this.add(this.connectionLabel);
        this.connectionTextField = new JTextField("", 32);
        this.connectionTextField.setActionCommand("connect");
        this.connectionTextField.addActionListener((ActionListener)actionListener);
        this.add(this.connectionTextField);
        this.newConnectionButton = new JButton("...");
        this.newConnectionButton.setActionCommand("newConnection");
        this.newConnectionButton.addActionListener((ActionListener)actionListener);
        this.newConnectionButton.setEnabled(SerialNumberHelper.hasValidatedSerialNumber());
        this.add(this.newConnectionButton);
        this.connectButton = new JButton(LanguageHelper.getText("loggingPanel.connect"));
        this.connectButton.setPreferredSize(new Dimension(140, 24));
        this.connectButton.setActionCommand("connect");
        this.connectButton.addActionListener((ActionListener)actionListener);
        this.add(this.connectButton);
        SimpleEventQueue.subscribe((Object)this);
    }

    private void setConnected(boolean connected) {
        this.connected = connected;
        if (connected) {
            this.setBackground(ColorHelper.CONNECTED);
            this.connectButton.setText(LanguageHelper.getText("loggingPanel.disconnect"));
            this.connectButton.setActionCommand("disconnect");
            this.connectionTextField.setActionCommand("disconnect");
            this.connectButton.requestFocus();
        } else {
            this.setBackground(ColorHelper.DISCONNECTED);
            this.connectButton.setText(LanguageHelper.getText("loggingPanel.connect"));
            this.connectButton.setActionCommand("connect");
            this.connectionTextField.setActionCommand("connect");
            this.connectionTextField.requestFocus();
        }
        this.connectionTextField.setEnabled(!connected);
        if (SerialNumberHelper.hasValidatedSerialNumber()) {
            this.newConnectionButton.setEnabled(!connected);
        }
        this.requestFocus();
        this.connectButton.requestFocus();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getCurrentConnection() {
        if (this.connected) {
            return this.connectionUrl.getPath();
        }
        return LanguageHelper.getText("loggingPanel.notConnected");
    }

    @Processing(value={ValidSerialNumberGivenEvent.class})
    private void onValidSerialNumber() {
        if (!this.connected) {
            this.newConnectionButton.setEnabled(true);
        }
    }

    @Processing(value={NewConnectionForIdEvent.class})
    private void process(NewConnectionForIdEvent event) {
        if (event.getId() == this.id) {
            this.connectionUrl = event.getConnectionUrl();
            this.connectionTextField.setText(this.connectionUrl.getPath());
        }
    }

    @Processing(value={ConnectionEstablishedEvent.class})
    private void process(ConnectionEstablishedEvent event) {
        if (event.getId() == this.id) {
            this.connectionUrl = event.getConnectionUrl();
            this.setConnected(true);
        }
    }

    @Processing(value={ConnectionClosedEvent.class})
    private void process(ConnectionClosedEvent event) {
        if (event.getId() == this.id) {
            this.connectionUrl = null;
            this.setConnected(false);
        }
    }

    @Processing(value={CloseTabEvent.class})
    private void process(CloseTabEvent event) {
        if (event.getId() == this.id) {
            SimpleEventQueue.unsubscribe((Object)this);
        }
    }

    @Processing(value={LanguageChangedEvent.class})
    private void process(LanguageChangedEvent event) {
        this.connectionLabel.setText(LanguageHelper.getText("loggingPanel.connection"));
        this.connectionTextField.setActionCommand(LanguageHelper.getText(this.connected ? "loggingPanel.disconnect" : "loggingPanel.connect"));
        this.connectButton.setText(LanguageHelper.getText(this.connected ? "loggingPanel.disconnect" : "loggingPanel.connect"));
    }

    @ActionCommand(value={"connect"})
    private void connect() {
        this.connectionUrl = new ConnectionUrl(this.connectionTextField.getText().trim());
        if (this.connectionUrl.getType() == null) {
            SimpleEventQueue.publish((Event)new ErrorEvent(ErrorEvent.ErrorCode.INVALID_CONNECTION_URL_GIVEN, this.connectionTextField.getText().trim()));
        } else {
            SimpleEventQueue.publish((Event)new NewConnectionForIdEvent(this.id, this.connectionUrl));
        }
    }

    @ActionCommand(value={"disconnect"})
    private void disconnect() {
        SimpleEventQueue.publish((Event)new CloseConnectionEvent(this.id));
    }

    @ActionCommand(value={"newConnection"})
    private void newConnection() {
        SimpleEventQueue.publish((Event)new ShowNewConnectionEvent());
    }
}

