/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.panels;

import de.jaggl.logging.mslogger.components.buttons.CloseButton;
import de.jaggl.logging.mslogger.domain.ConnectionUrl;
import de.jaggl.logging.mslogger.events.AddToFavoritesEvent;
import de.jaggl.logging.mslogger.events.ConnectAllFavoritesEvent;
import de.jaggl.logging.mslogger.events.FavoritesVisibilityChangedEvent;
import de.jaggl.logging.mslogger.events.LanguageChangedEvent;
import de.jaggl.logging.mslogger.events.NewConnectionEvent;
import de.jaggl.logging.mslogger.events.ToggleFavoritesVisibilityEvent;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.logging.mslogger.helpers.ListHelper;
import de.jaggl.logging.mslogger.helpers.PreferencesHelper;
import de.jaggl.logging.mslogger.helpers.SerialNumberHelper;
import de.jaggl.logging.mslogger.listeners.DoubleClickMouseAdapter;
import de.jaggl.logging.mslogger.listeners.EnterKeyAdapter;
import de.jaggl.utils.events.actioncommand.annotations.ActionCommand;
import de.jaggl.utils.events.actioncommand.listeners.AnnotatedActionListener;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class FavoritesPanel
extends JPanel {
    private JList<ConnectionUrl> favoritesList;
    private static final long serialVersionUID = 7350103493248200919L;
    private DefaultListModel<ConnectionUrl> listModel = new DefaultListModel();
    private JLabel titleLabel;

    public FavoritesPanel() {
        this.loadFavorites();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY));
        this.favoritesList = new JList<ConnectionUrl>(this.listModel);
        if (this.listModel.getSize() > 0) {
            this.favoritesList.setSelectedIndex(0);
        }
        this.setPreferredSize(new Dimension(200, 1));
        this.setMinimumSize(new Dimension(200, 1));
        this.favoritesList.addMouseListener(new DoubleClickMouseAdapter(new OpenFavoriteRunnable()));
        this.favoritesList.addKeyListener(new EnterKeyAdapter(new OpenFavoriteRunnable()));
        this.favoritesList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                int index;
                if (event.getKeyCode() == 8 || event.getKeyCode() == 127) {
                    if (JOptionPane.showConfirmDialog(FavoritesPanel.this, LanguageHelper.getText("confirmation.removeFavorites"), LanguageHelper.getText("confirmation.title"), 0) == 0) {
                        for (ConnectionUrl connectionUrl : FavoritesPanel.this.favoritesList.getSelectedValuesList()) {
                            FavoritesPanel.this.listModel.removeElement(connectionUrl);
                        }
                        FavoritesPanel.this.saveFavorites();
                    }
                } else if (event.getKeyCode() == 38 && event.isMetaDown()) {
                    int index2 = FavoritesPanel.this.favoritesList.getSelectedIndex();
                    if (index2 > 0) {
                        ConnectionUrl connectionUrl = (ConnectionUrl)FavoritesPanel.this.listModel.remove(index2);
                        FavoritesPanel.this.listModel.insertElementAt(connectionUrl, index2 - 1);
                        FavoritesPanel.this.favoritesList.setSelectedIndex(index2 - 1);
                        FavoritesPanel.this.saveFavorites();
                    }
                } else if (event.getKeyCode() == 40 && event.isMetaDown() && (index = FavoritesPanel.this.favoritesList.getSelectedIndex()) < FavoritesPanel.this.favoritesList.getModel().getSize() - 1) {
                    ConnectionUrl connectionUrl = (ConnectionUrl)FavoritesPanel.this.listModel.remove(index);
                    FavoritesPanel.this.listModel.insertElementAt(connectionUrl, index + 1);
                    FavoritesPanel.this.favoritesList.setSelectedIndex(index + 1);
                    FavoritesPanel.this.saveFavorites();
                }
            }
        });
        this.favoritesList.setCellRenderer(new FavoritesListCellRenderer());
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBackground(new Color(220, 220, 220));
        this.titleLabel = new JLabel(LanguageHelper.getText("favorites.title"), 0);
        this.titleLabel.setFocusable(false);
        titlePanel.add((Component)this.titleLabel, "Center");
        CloseButton closeButton = new CloseButton();
        closeButton.setActionCommand("close");
        closeButton.addActionListener((ActionListener)new AnnotatedActionListener((Object)this));
        titlePanel.add((Component)closeButton, "After");
        this.add((Component)titlePanel, "First");
        this.add(this.favoritesList, "Center");
        SimpleEventQueue.subscribe((Object)this);
    }

    @Processing(value={ToggleFavoritesVisibilityEvent.class})
    private void onToggleFavoritesVisibility() {
        if (SerialNumberHelper.hasValidatedSerialNumber()) {
            this.setVisible(!this.isVisible());
            if (this.isVisible()) {
                this.favoritesList.requestFocus();
            }
            PreferencesHelper.setPref("favoritesVisible", this.isVisible());
            SimpleEventQueue.publish((Event)new FavoritesVisibilityChangedEvent(this.isVisible()));
        }
    }

    @Processing(value={ConnectAllFavoritesEvent.class})
    private void onConnectAllFavorites() {
        if (SerialNumberHelper.hasValidatedSerialNumber()) {
            for (int i = 0; i < this.listModel.size(); ++i) {
                SimpleEventQueue.publish((Event)new NewConnectionEvent(this.listModel.getElementAt(i)));
            }
        }
    }

    @Processing(value={AddToFavoritesEvent.class})
    private void process(AddToFavoritesEvent event) {
        if (SerialNumberHelper.hasValidatedSerialNumber() && !this.listModel.contains(event.getConnectionUrl())) {
            this.listModel.addElement(event.getConnectionUrl());
            this.saveFavorites();
        }
    }

    @Processing(value={LanguageChangedEvent.class})
    private void process() {
        this.titleLabel.setText(LanguageHelper.getText("favorites.title"));
    }

    private void saveFavorites() {
        PreferencesHelper.setPref("favorites", de.jaggl.utils.common.helpers.ListHelper.implodeList((String)",", ListHelper.getElements(this.listModel)));
    }

    private void loadFavorites() {
        String[] favorites;
        this.listModel.clear();
        for (String favorite : favorites = PreferencesHelper.pref("favorites", "").split(",")) {
            ConnectionUrl connectionUrl = new ConnectionUrl(favorite);
            if (connectionUrl.getType() == null) continue;
            this.listModel.addElement(connectionUrl);
        }
    }

    @ActionCommand(value={"close"})
    private void close() {
        SimpleEventQueue.publish((Event)new ToggleFavoritesVisibilityEvent());
    }

    private class OpenFavoriteRunnable
    implements Runnable {
        private OpenFavoriteRunnable() {
        }

        @Override
        public void run() {
            for (ConnectionUrl connectionUrl : FavoritesPanel.this.favoritesList.getSelectedValuesList()) {
                SimpleEventQueue.publish((Event)new NewConnectionEvent(connectionUrl));
            }
            FavoritesPanel.this.favoritesList.requestFocus();
        }
    }

    private class FavoritesListCellRenderer
    implements ListCellRenderer<ConnectionUrl> {
        private FavoritesListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ConnectionUrl> list, ConnectionUrl connectionUrl, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setOpaque(false);
            JLabel label = new JLabel(connectionUrl.toString());
            label.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            if (isSelected) {
                label.setBackground(SystemColor.controlHighlight);
                label.setForeground(SystemColor.controlLtHighlight);
                label.setOpaque(true);
                if (cellHasFocus) {
                    panel.setBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow));
                } else {
                    panel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, SystemColor.controlHighlight));
                }
            }
            panel.add((Component)label, "Center");
            return panel;
        }
    }
}

