/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.panels;

import de.jaggl.logging.mslogger.components.comboboxes.SelectLogLevelComboBox;
import de.jaggl.logging.mslogger.domain.Filter;
import de.jaggl.logging.mslogger.events.CloseTabEvent;
import de.jaggl.logging.mslogger.events.FilterChangedEvent;
import de.jaggl.logging.mslogger.events.LanguageChangedEvent;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.utils.events.actioncommand.annotations.ActionCommand;
import de.jaggl.utils.events.actioncommand.listeners.AnnotatedActionListener;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FilterPanel
extends JPanel {
    private static final long serialVersionUID = 3725199332631802027L;
    private SelectLogLevelComboBox levelFilterComboBox;
    private JTextField messageFilterTextField;
    private Filter filter;
    private long id;
    private JLabel filterLabel;

    public FilterPanel(long id) {
        this.id = id;
        this.filterLabel = new JLabel(LanguageHelper.getText("loggingPanel.filter"));
        this.add(this.filterLabel);
        this.levelFilterComboBox = new SelectLogLevelComboBox(true);
        this.levelFilterComboBox.setActionCommand("filterChanged");
        this.levelFilterComboBox.addActionListener((ActionListener)new AnnotatedActionListener((Object)this));
        this.add(this.levelFilterComboBox);
        this.messageFilterTextField = new JTextField(25);
        this.messageFilterTextField.getDocument().addDocumentListener(new MessageFilterDocumentListener());
        this.add(this.messageFilterTextField);
        this.filter = new Filter();
        SimpleEventQueue.subscribe((Object)this);
    }

    @ActionCommand(value={"filterChanged"})
    private void updateFilter() {
        this.filter.setLevel(this.levelFilterComboBox.getSelectedLevel());
        this.filter.setMessage(this.messageFilterTextField.getText());
        SimpleEventQueue.publish((Event)new FilterChangedEvent(this.id, this.filter));
    }

    @Processing(value={LanguageChangedEvent.class})
    private void onLanguageChanged() {
        this.filterLabel.setText(LanguageHelper.getText("loggingPanel.filter"));
    }

    @Processing(value={CloseTabEvent.class})
    private void process(CloseTabEvent event) {
        if (event.getId() == this.id) {
            SimpleEventQueue.unsubscribe((Object)this);
        }
    }

    private class MessageFilterDocumentListener
    implements DocumentListener {
        private MessageFilterDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            FilterPanel.this.updateFilter();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            FilterPanel.this.updateFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            FilterPanel.this.updateFilter();
        }
    }
}

