/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.panels;

import de.jaggl.logging.mslogger.components.panels.ConnectionPanel;
import de.jaggl.logging.mslogger.components.panels.FilterPanel;
import de.jaggl.logging.mslogger.components.panels.LoggingTabbedPanel;
import de.jaggl.logging.mslogger.components.tables.LoggingTable;
import de.jaggl.logging.mslogger.connectors.Connector;
import de.jaggl.logging.mslogger.events.ClearLoggingTableEvent;
import de.jaggl.logging.mslogger.events.CloseConnectionEvent;
import de.jaggl.logging.mslogger.events.CloseTabEvent;
import de.jaggl.logging.mslogger.events.ErrorEvent;
import de.jaggl.logging.mslogger.events.FollowStateChangedEvent;
import de.jaggl.logging.mslogger.events.LanguageChangedEvent;
import de.jaggl.logging.mslogger.events.NewConnectionForIdEvent;
import de.jaggl.logging.mslogger.events.ValidSerialNumberGivenEvent;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.logging.mslogger.helpers.SerialNumberHelper;
import de.jaggl.utils.events.actioncommand.annotations.ActionCommand;
import de.jaggl.utils.events.actioncommand.listeners.AnnotatedActionListener;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingPanel
extends JPanel {
    private static final long serialVersionUID = -1791417125271964443L;
    private static Log log = LogFactory.getLog(LoggingPanel.class);
    private LoggingTable loggingTable;
    private ConnectionPanel connectionPanel;
    private LoggingTabbedPanel parent;
    private JCheckBox followCheckBox;
    private JButton clearLogButton;
    private FilterPanel filterPanel;
    private long id;
    private Connector connector;

    public LoggingPanel(LoggingTabbedPanel parent, long id) {
        this.parent = parent;
        this.id = id;
        this.setLayout(new BorderLayout());
        this.loggingTable = new LoggingTable(id);
        this.loggingTable.setShowGrid(false);
        this.loggingTable.setShowHorizontalLines(true);
        JScrollPane scrollList = new JScrollPane(this.loggingTable);
        scrollList.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.LIGHT_GRAY));
        this.connectionPanel = new ConnectionPanel(id);
        this.add((Component)this.connectionPanel, "First");
        this.add((Component)scrollList, "Center");
        this.add((Component)this.getBottomPanel(), "Last");
        SimpleEventQueue.subscribe((Object)this);
    }

    private JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JPanel bottomRightPanel = new JPanel();
        this.followCheckBox = new JCheckBox(LanguageHelper.getText("loggingPanel.follow"), true);
        this.followCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                SimpleEventQueue.publish((Event)new FollowStateChangedEvent(LoggingPanel.this.id, LoggingPanel.this.followCheckBox.isSelected()));
            }
        });
        bottomRightPanel.add((Component)this.followCheckBox, "Before");
        this.clearLogButton = new JButton(LanguageHelper.getText("loggingPanel.clear"));
        this.clearLogButton.setActionCommand("clear");
        this.clearLogButton.addActionListener((ActionListener)new AnnotatedActionListener((Object)this));
        bottomRightPanel.add((Component)this.clearLogButton, "After");
        this.filterPanel = new FilterPanel(this.id);
        bottomPanel.add((Component)this.filterPanel, "Center");
        if (!SerialNumberHelper.hasValidatedSerialNumber()) {
            this.filterPanel.setVisible(false);
        }
        bottomPanel.add((Component)bottomRightPanel, "After");
        return bottomPanel;
    }

    @ActionCommand(value={"clear"})
    private void onClear() {
        SimpleEventQueue.publish((Event)new ClearLoggingTableEvent(this.id));
    }

    public long getId() {
        return this.id;
    }

    public String getCurrentConnection() {
        return this.connectionPanel.getCurrentConnection();
    }

    @Override
    public String toString() {
        return this.getCurrentConnection();
    }

    public Connector getConnector() {
        return this.connector;
    }

    public boolean isConnected() {
        return this.connectionPanel.isConnected();
    }

    public LoggingTable getLoggingTable() {
        return this.loggingTable;
    }

    @Processing(value={ValidSerialNumberGivenEvent.class})
    private void onValidSerialNumberGiven() {
        this.filterPanel.setVisible(true);
    }

    @Processing(value={CloseTabEvent.class})
    private void process(CloseTabEvent event) {
        if (event.getId() == this.id) {
            SimpleEventQueue.publish((Event)new CloseConnectionEvent(this.id));
            int index = this.parent.indexOfComponent(this);
            if (this.parent.getTabCount() > 2) {
                this.parent.setChangeListenerActive(false);
                this.parent.remove(index);
                if (this.parent.getSelectedComponent() == this.parent.getAddPanel()) {
                    this.parent.setSelectedIndex(this.parent.getTabCount() - 2);
                }
                this.parent.setChangeListenerActive(true);
            } else {
                this.parent.remove(index);
            }
            SimpleEventQueue.unsubscribe((Object)this);
            this.parent.requestFocus();
        }
    }

    @Processing(value={NewConnectionForIdEvent.class})
    private void process(NewConnectionForIdEvent event) {
        if (event.getId() == this.id) {
            try {
                this.connector = event.getConnectionUrl().getType().getNewConnectorInstance(this.id);
                this.connector.connect(event.getConnectionUrl());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                SimpleEventQueue.publish((Event)new ErrorEvent(ErrorEvent.ErrorCode.CONNECTION_COULD_NOT_BE_ESTABLISHED, event.getConnectionUrl()));
            }
        }
    }

    @Processing(value={LanguageChangedEvent.class})
    private void onLanguageChanged() {
        this.followCheckBox.setText(LanguageHelper.getText("loggingPanel.follow"));
        this.clearLogButton.setText(LanguageHelper.getText("loggingPanel.clear"));
    }
}

