/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.panels;

import de.jaggl.logging.mslogger.components.buttons.ExtendedTabButton;
import de.jaggl.logging.mslogger.components.panels.LoggingPanel;
import de.jaggl.logging.mslogger.domain.ConnectionUrl;
import de.jaggl.logging.mslogger.events.AddCurrentTabToFavoritesEvent;
import de.jaggl.logging.mslogger.events.AddToFavoritesEvent;
import de.jaggl.logging.mslogger.events.ClearCurrentLoggingTableEvent;
import de.jaggl.logging.mslogger.events.ClearLoggingTableEvent;
import de.jaggl.logging.mslogger.events.CloseCurrentTabEvent;
import de.jaggl.logging.mslogger.events.CloseTabEvent;
import de.jaggl.logging.mslogger.events.NewConnectionEvent;
import de.jaggl.logging.mslogger.events.NewConnectionForIdEvent;
import de.jaggl.logging.mslogger.events.NewTabEvent;
import de.jaggl.logging.mslogger.events.ShowCurrentConnectionSettingsEvent;
import de.jaggl.logging.mslogger.events.SwitchTabEvent;
import de.jaggl.logging.mslogger.events.TabSelectedEvent;
import de.jaggl.logging.mslogger.events.ValidSerialNumberGivenEvent;
import de.jaggl.logging.mslogger.helpers.ColorHelper;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.logging.mslogger.helpers.SerialNumberHelper;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LoggingTabbedPanel
extends JTabbedPane {
    private static final long serialVersionUID = 7401842648282181138L;
    private JPanel addPanel = new JPanel();
    private boolean changeListenerActive = true;
    private long idCounter = 0L;

    public LoggingTabbedPanel() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (LoggingTabbedPanel.this.getSelectedComponent() == LoggingTabbedPanel.this.addPanel) {
                    if (LoggingTabbedPanel.this.changeListenerActive) {
                        SimpleEventQueue.publish((Event)new NewTabEvent());
                    }
                } else {
                    long id = ((LoggingPanel)LoggingTabbedPanel.this.getComponentAt(LoggingTabbedPanel.this.getSelectedIndex())).getId();
                    SimpleEventQueue.publish((Event)new TabSelectedEvent(id));
                }
            }
        });
        this.changeListenerActive = false;
        super.addTab(SerialNumberHelper.hasValidatedSerialNumber() ? "+" : "+ (PRO)", this.addPanel);
        this.changeListenerActive = true;
        this.setMinimumSize(new Dimension(800, 200));
        SimpleEventQueue.subscribe((Object)this);
    }

    @Processing(value={NewConnectionEvent.class})
    private void process(NewConnectionEvent event) {
        LoggingPanel currentLoggingPanel = this.getCurrentLoggingPanel();
        if (currentLoggingPanel.isConnected()) {
            SimpleEventQueue.publish((Event)new NewTabEvent(event.getConnectionUrl()));
        } else {
            SimpleEventQueue.publish((Event)new NewConnectionForIdEvent(currentLoggingPanel.getId(), event.getConnectionUrl()));
        }
    }

    public JPanel getAddPanel() {
        return this.addPanel;
    }

    protected long getNewId() {
        return ++this.idCounter;
    }

    @Processing(value={SwitchTabEvent.class})
    private void process(SwitchTabEvent event) {
        if (event.getDirection() == SwitchTabEvent.Direction.FORWARD && this.getSelectedIndex() < this.getTabCount() - 2) {
            this.setSelectedIndex(this.getSelectedIndex() + 1);
        } else if (event.getDirection() == SwitchTabEvent.Direction.BACKWARD && this.getSelectedIndex() > 0) {
            this.setSelectedIndex(this.getSelectedIndex() - 1);
        }
    }

    @Processing(value={ValidSerialNumberGivenEvent.class})
    private void onValidSerialNumberGiven() {
        this.setTitleAt(this.getTabCount() - 1, "+");
    }

    @Processing(value={NewTabEvent.class})
    private void process(NewTabEvent event) {
        if (this.getTabCount() == 2 && !SerialNumberHelper.hasValidatedSerialNumber()) {
            this.setSelectedIndex(0);
            return;
        }
        long id = this.getNewId();
        LoggingPanel loggingPanel = new LoggingPanel(this, id);
        this.addTab(LanguageHelper.getText("loggingPanel.notConnected"), loggingPanel);
        this.setBackgroundAt(this.getTabCount() - 2, ColorHelper.DISCONNECTED);
        if (event.getConnectionUrl() != null) {
            SimpleEventQueue.publish((Event)new NewConnectionForIdEvent(id, event.getConnectionUrl()));
        }
        loggingPanel.requestFocus();
    }

    @Processing(value={AddCurrentTabToFavoritesEvent.class})
    private void onAddCurrentTabToFavorites() {
        ConnectionUrl connectionUrl;
        if (SerialNumberHelper.hasValidatedSerialNumber() && (connectionUrl = new ConnectionUrl(this.getCurrentLoggingPanel().getCurrentConnection())).getType() != null) {
            SimpleEventQueue.publish((Event)new AddToFavoritesEvent(connectionUrl));
        }
    }

    @Processing(value={ClearCurrentLoggingTableEvent.class})
    private void onClearCurrentLoggingTable() {
        SimpleEventQueue.publish((Event)new ClearLoggingTableEvent(this.getCurrentLoggingPanel().getId()));
    }

    @Processing(value={ShowCurrentConnectionSettingsEvent.class})
    private void onShowCurrentConnectionSettings() {
        LoggingPanel loggingPanel = this.getCurrentLoggingPanel();
        if (loggingPanel.isConnected()) {
            SimpleEventQueue.publish((Event)this.getCurrentLoggingPanel().getConnector().getShowConnectionSettingsEvent());
        }
    }

    @Processing(value={CloseCurrentTabEvent.class})
    private void onCloseCurrentTab() {
        SimpleEventQueue.publish((Event)new CloseTabEvent(this.getCurrentLoggingPanel().getId()));
    }

    public void setChangeListenerActive(boolean changeListenerActive) {
        this.changeListenerActive = changeListenerActive;
    }

    private LoggingPanel getCurrentLoggingPanel() {
        return (LoggingPanel)this.getComponentAt(this.getSelectedIndex());
    }

    @Override
    public void addTab(String title, Component component) {
        this.changeListenerActive = false;
        this.insertTab(title, null, component, null, this.getTabCount() - 1);
        long id = ((LoggingPanel)component).getId();
        this.setTabComponentAt(this.getTabCount() - 2, new ExtendedTabButton(this, id));
        this.setSelectedIndex(this.getTabCount() - 2);
        this.changeListenerActive = true;
    }
}

