/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.renderers;

import de.jaggl.logging.mslogger.helpers.ColorHelper;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class TimestampTableCellRenderer
implements TableCellRenderer {
    private DateFormat dateFormat;

    public TimestampTableCellRenderer(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        Long timestamp = (Long)object;
        JLabel timeLabel = new JLabel(this.dateFormat.format(timestamp), 0);
        timeLabel.setBackground(ColorHelper.getBackgroundColor(row));
        timeLabel.setForeground(Color.GRAY);
        if (isSelected) {
            timeLabel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY));
        }
        timeLabel.setOpaque(true);
        return timeLabel;
    }
}

