/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.runnables;

import de.jaggl.logging.mslogger.events.NotificationEvent;
import de.jaggl.logging.mslogger.helpers.PreferencesHelper;
import de.jaggl.logging.mslogger.helpers.SerialNumberHelper;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class NotificationAdder
implements Runnable {
    private JTable table;
    private NotificationEvent notificationEvent;
    private int maxShownLines;
    private DefaultTableModel model;
    private boolean follow;

    public NotificationAdder(JTable table, NotificationEvent notificationEvent, boolean follow) {
        this.follow = follow;
        this.maxShownLines = PreferencesHelper.pref("maxShownLines", 1000);
        if (this.maxShownLines <= 0 || this.maxShownLines > 100000) {
            this.maxShownLines = 100000;
        }
        if (!SerialNumberHelper.hasValidatedSerialNumber()) {
            this.maxShownLines = 100;
        }
        this.table = table;
        this.notificationEvent = notificationEvent;
        this.model = (DefaultTableModel)table.getModel();
    }

    @Override
    public void run() {
        this.model.addRow(this.toVector(this.notificationEvent));
        if (this.model.getRowCount() > this.maxShownLines) {
            this.model.removeRow(0);
        }
        if (this.follow) {
            this.selectAndShowLastInsertedRow();
        }
    }

    private void selectAndShowLastInsertedRow() {
        int index = this.table.convertRowIndexToView(this.model.getRowCount() - 1);
        if (index != -1) {
            this.table.getSelectionModel().setSelectionInterval(index, index);
            Rectangle rect = this.table.getCellRect(index, 0, true);
            this.table.scrollRectToVisible(rect);
        }
    }

    private Vector<Object> toVector(NotificationEvent notificationEvent) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(notificationEvent.getSequenceNumber());
        vector.add(notificationEvent.getTimeStamp());
        vector.add((Object)notificationEvent);
        vector.add(notificationEvent.getLevel());
        String trace = notificationEvent.getTrace();
        vector.add(trace != null && !trace.isEmpty());
        return vector;
    }
}

