/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.components.tables;

import de.jaggl.logging.mslogger.comparators.LevelComparator;
import de.jaggl.logging.mslogger.comparators.LongComparator;
import de.jaggl.logging.mslogger.comparators.NotificationEventComparator;
import de.jaggl.logging.mslogger.components.renderers.LevelTableCellRenderer;
import de.jaggl.logging.mslogger.components.renderers.NotificationTableCellRenderer;
import de.jaggl.logging.mslogger.components.renderers.SequenceNumberTableCellRenderer;
import de.jaggl.logging.mslogger.components.renderers.TimestampTableCellRenderer;
import de.jaggl.logging.mslogger.components.renderers.TraceTableCellRenderer;
import de.jaggl.logging.mslogger.components.runnables.NotificationAdder;
import de.jaggl.logging.mslogger.domain.Filter;
import de.jaggl.logging.mslogger.events.ChangedMaxShownLinesEvent;
import de.jaggl.logging.mslogger.events.ClearLoggingTableEvent;
import de.jaggl.logging.mslogger.events.CloseTabEvent;
import de.jaggl.logging.mslogger.events.FilterChangedEvent;
import de.jaggl.logging.mslogger.events.FollowStateChangedEvent;
import de.jaggl.logging.mslogger.events.LanguageChangedEvent;
import de.jaggl.logging.mslogger.events.NotificationEvent;
import de.jaggl.logging.mslogger.events.ShowLogDetailsEvent;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.logging.mslogger.listeners.DoubleClickMouseAdapter;
import de.jaggl.logging.mslogger.listeners.EnterKeyAdapter;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class LoggingTable
extends JTable {
    private static final long serialVersionUID = 3729167504152352931L;
    private DefaultTableModel model;
    private DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss,SSS");
    private TableRowSorter<DefaultTableModel> rowSorter;
    private Filter filter = new Filter();
    private boolean follow = true;
    private long id;

    public LoggingTable(long id) {
        this.id = id;
        Column[] columns = new Column[]{new Column(LanguageHelper.getText("loggingPanel.columns.sequenceNumber"), 50, new SequenceNumberTableCellRenderer(), new LongComparator()), new Column(LanguageHelper.getText("loggingPanel.columns.dateTime"), 180, new TimestampTableCellRenderer(this.dateFormat), null), new Column(LanguageHelper.getText("loggingPanel.columns.message"), -1, new NotificationTableCellRenderer(), new NotificationEventComparator()), new Column(LanguageHelper.getText("loggingPanel.columns.level"), 55, new LevelTableCellRenderer(), new LevelComparator()), new Column(LanguageHelper.getText("loggingPanel.columns.trace"), 50, new TraceTableCellRenderer(), null)};
        this.model = new DefaultTableModel(this.getCaptions(columns), 0);
        this.setModel(this.model);
        this.rowSorter = new TableRowSorter<DefaultTableModel>(this.model);
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            if (column.getWidth() != -1) {
                tableColumn.setPreferredWidth(column.getWidth());
                tableColumn.setMaxWidth(column.getWidth());
                tableColumn.setMinWidth(column.getWidth());
            }
            if (column.getRenderer() != null) {
                tableColumn.setCellRenderer(column.getRenderer());
            }
            if (column.getComparator() == null) continue;
            this.rowSorter.setComparator(i, column.getComparator());
        }
        this.setShowGrid(false);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setIntercellSpacing(new Dimension(0, 1));
        this.getTableHeader().setResizingAllowed(false);
        this.addMouseListener(new DoubleClickMouseAdapter(new OpenLogDetailsRunnable()));
        this.addKeyListener(new EnterKeyAdapter(new OpenLogDetailsRunnable()));
        this.rowSorter.setRowFilter(new LogRowFilter());
        this.rowSorter.toggleSortOrder(1);
        this.setRowSorter(this.rowSorter);
        SimpleEventQueue.subscribe((Object)this);
    }

    private String[] getCaptions(Column[] columns) {
        String[] captions = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            captions[i] = columns[i].getCaption();
        }
        return captions;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int vColIndex) {
        return false;
    }

    @Processing(value={FollowStateChangedEvent.class})
    private void process(FollowStateChangedEvent event) {
        if (event.getId() == this.id) {
            this.follow = event.getFollow();
        }
    }

    @Processing(value={NotificationEvent.class})
    private void process(NotificationEvent event) {
        if (event.getId() == this.id) {
            SwingUtilities.invokeLater(new NotificationAdder(this, event, this.follow));
        }
    }

    @Processing(value={ChangedMaxShownLinesEvent.class})
    private void process(ChangedMaxShownLinesEvent event) {
        int maxShownLines = event.getMaxShownLines();
        if (maxShownLines <= 0) {
            maxShownLines = 100000;
        }
        while (this.getRowCount() > maxShownLines) {
            this.model.removeRow(0);
        }
    }

    @Processing(value={ClearLoggingTableEvent.class})
    private void process(ClearLoggingTableEvent event) {
        if (event.getId() == this.id) {
            this.model.getDataVector().removeAllElements();
            this.model.fireTableDataChanged();
        }
    }

    @Processing(value={FilterChangedEvent.class})
    private void process(FilterChangedEvent event) {
        if (event.getId() == this.id) {
            this.filter = event.getFilter();
            this.rowSorter.sort();
        }
    }

    @Processing(value={CloseTabEvent.class})
    private void process(CloseTabEvent event) {
        if (event.getId() == this.id) {
            SimpleEventQueue.unsubscribe((Object)this);
        }
    }

    @Processing(value={LanguageChangedEvent.class})
    private void onLanguageChanged() {
        this.getColumnModel().getColumn(0).setHeaderValue(LanguageHelper.getText("loggingPanel.columns.sequenceNumber"));
        this.getColumnModel().getColumn(1).setHeaderValue(LanguageHelper.getText("loggingPanel.columns.dateTime"));
        this.getColumnModel().getColumn(2).setHeaderValue(LanguageHelper.getText("loggingPanel.columns.message"));
        this.getColumnModel().getColumn(3).setHeaderValue(LanguageHelper.getText("loggingPanel.columns.level"));
        this.getColumnModel().getColumn(4).setHeaderValue(LanguageHelper.getText("loggingPanel.columns.trace"));
    }

    private class OpenLogDetailsRunnable
    implements Runnable {
        private OpenLogDetailsRunnable() {
        }

        @Override
        public void run() {
            int row = LoggingTable.this.convertRowIndexToModel(LoggingTable.this.getSelectionModel().getMinSelectionIndex());
            NotificationEvent notificationEvent = (NotificationEvent)((Object)LoggingTable.this.getModel().getValueAt(row, 2));
            SimpleEventQueue.publish((Event)new ShowLogDetailsEvent(notificationEvent));
        }
    }

    private class Column {
        private String caption;
        private int width;
        private TableCellRenderer renderer;
        private Comparator<?> comparator;

        public Column(String caption, int width, TableCellRenderer renderer, Comparator<?> comparator) {
            this.caption = caption;
            this.width = width;
            this.renderer = renderer;
            this.comparator = comparator;
        }

        public String getCaption() {
            return this.caption;
        }

        public int getWidth() {
            return this.width;
        }

        public TableCellRenderer getRenderer() {
            return this.renderer;
        }

        public Comparator<?> getComparator() {
            return this.comparator;
        }
    }

    private class LogRowFilter
    extends RowFilter<Object, Object> {
        private LogRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
            if (LoggingTable.this.filter.getMessage() != null && !LoggingTable.this.filter.getMessage().isEmpty() && !entry.getStringValue(2).toLowerCase().contains(LoggingTable.this.filter.getMessage().toLowerCase())) {
                return false;
            }
            return LoggingTable.this.filter.getLevel() == null || LoggingTable.this.filter.getLevel().equals(entry.getValue(3));
        }
    }
}

