/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.connectors;

import com.thoughtworks.xstream.XStream;
import de.jaggl.logging.mslogger.connectors.Connector;
import de.jaggl.logging.mslogger.domain.ConnectionUrl;
import de.jaggl.logging.mslogger.domain.JmsLoggingEvent;
import de.jaggl.logging.mslogger.events.ClearLoggingTableEvent;
import de.jaggl.logging.mslogger.events.CloseConnectionEvent;
import de.jaggl.logging.mslogger.events.ConnectionClosedEvent;
import de.jaggl.logging.mslogger.events.ConnectionEstablishedEvent;
import de.jaggl.logging.mslogger.events.ErrorEvent;
import de.jaggl.logging.mslogger.events.NotificationEvent;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;

public class JmsConnector
implements Connector {
    private Connection connection;
    private MessageConsumer consumer;
    private long id;
    private static Log log = LogFactory.getLog(JmsConnector.class);
    private XStream xStream;

    public JmsConnector(long id) {
        this.id = id;
        this.xStream = new XStream();
        this.xStream.processAnnotations(JmsLoggingEvent.class);
        SimpleEventQueue.subscribe((Object)this);
    }

    @Override
    public Event getShowConnectionSettingsEvent() {
        return null;
    }

    @Override
    public void connect(ConnectionUrl connectionUrl) {
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://" + this.getHostAndPort(connectionUrl));
            this.connection = connectionFactory.createConnection();
            this.connection.setExceptionListener((ExceptionListener)new JmsLoggingExceptionListener());
            this.connection.start();
            Session session = this.connection.createSession(false, 1);
            Topic destination = session.createTopic("com.avides.logging." + this.getDestination(connectionUrl));
            this.consumer = session.createConsumer((Destination)destination);
            this.consumer.setMessageListener((MessageListener)new JmsLoggingMessageListener());
            SimpleEventQueue.publish((Event)new ClearLoggingTableEvent(this.id));
            SimpleEventQueue.publish((Event)new ConnectionEstablishedEvent(this.id, connectionUrl));
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            SimpleEventQueue.publish((Event)new CloseConnectionEvent(this.id));
            SimpleEventQueue.publish((Event)new ErrorEvent(ErrorEvent.ErrorCode.CONNECTION_COULD_NOT_BE_ESTABLISHED, connectionUrl));
        }
    }

    @Processing(value={CloseConnectionEvent.class})
    public void process(CloseConnectionEvent event) {
        if (event.getId() == this.id) {
            this.disconnect();
        }
    }

    private void disconnect() {
        try {
            this.connection.setExceptionListener(null);
        }
        catch (JMSException e1) {
            // empty catch block
        }
        try {
            this.consumer.setMessageListener(null);
        }
        catch (JMSException e1) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        SimpleEventQueue.unsubscribe((Object)this);
        SimpleEventQueue.publish((Event)new ConnectionClosedEvent(this.id));
    }

    private String getHostAndPort(ConnectionUrl connectionUrl) {
        return connectionUrl.getPathWithoutType().replaceAll("/.+$", "");
    }

    private String getDestination(ConnectionUrl connectionUrl) {
        return connectionUrl.getPathWithoutType().replaceAll("^.*/", "");
    }

    private class JmsLoggingExceptionListener
    implements ExceptionListener {
        private JmsLoggingExceptionListener() {
        }

        public void onException(JMSException exception) {
            JmsConnector.this.disconnect();
        }
    }

    private class JmsLoggingMessageListener
    implements MessageListener {
        private JmsLoggingMessageListener() {
        }

        public void onMessage(Message message) {
            if (TextMessage.class.isAssignableFrom(message.getClass())) {
                TextMessage textMessage = (TextMessage)message;
                try {
                    JmsLoggingEvent event = (JmsLoggingEvent)JmsConnector.this.xStream.fromXML(textMessage.getText());
                    SimpleEventQueue.publish((Event)new NotificationEvent(JmsConnector.this.id, textMessage.getJMSTimestamp(), event.getMessage(), event.getType(), event.getSource(), event.getSequenceNumber(), Level.toLevel((String)event.getLevel()), event.getTrace(), event.getThread()));
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

