/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.connectors;

import de.jaggl.logging.jmx.JmxAppenderMBean;
import de.jaggl.logging.jmx.domain.MBeanName;
import de.jaggl.logging.mslogger.connectors.Connector;
import de.jaggl.logging.mslogger.domain.ConnectionUrl;
import de.jaggl.logging.mslogger.events.ClearLoggingTableEvent;
import de.jaggl.logging.mslogger.events.CloseConnectionEvent;
import de.jaggl.logging.mslogger.events.ConnectionClosedEvent;
import de.jaggl.logging.mslogger.events.ConnectionEstablishedEvent;
import de.jaggl.logging.mslogger.events.ErrorEvent;
import de.jaggl.logging.mslogger.events.NotificationEvent;
import de.jaggl.logging.mslogger.events.ShowJmxConnectionSettingsEvent;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import de.jaggl.utils.events.simple.domain.Event;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Map;
import javax.management.JMX;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;

public class JmxConnector
implements Connector {
    private static Log log = LogFactory.getLog(JmxConnector.class);
    private JMXConnector jmxConnector;
    private MBeanServerConnection connection;
    private JmxAppenderMBean jmxAppender;
    private ObjectName objectName;
    private JmxConnectionNotificationListener jmxConnectionNotificationListener;
    private JmxNotificationListener jmxNotificationListener;
    private long id;

    public JmxConnector(long id) {
        this.id = id;
        SimpleEventQueue.subscribe((Object)this);
    }

    @Override
    public void connect(ConnectionUrl connectionUrl) {
        try {
            JMXServiceURL url = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://%1$s/jmxrmi", this.getHostAndPort(connectionUrl)));
            this.jmxConnector = JMXConnectorFactory.connect(url);
            this.jmxConnectionNotificationListener = new JmxConnectionNotificationListener();
            this.jmxConnector.addConnectionNotificationListener(this.jmxConnectionNotificationListener, null, null);
            this.connection = this.jmxConnector.getMBeanServerConnection();
            this.objectName = MBeanName.getObjectName((String)this.getId(connectionUrl));
            this.jmxAppender = JMX.newMBeanProxy(this.connection, this.objectName, JmxAppenderMBean.class, true);
            this.jmxNotificationListener = new JmxNotificationListener();
            this.connection.addNotificationListener(this.objectName, this.jmxNotificationListener, null, null);
            SimpleEventQueue.publish((Event)new ClearLoggingTableEvent(this.id));
            try {
                ArrayList persistedNotifications = new ArrayList(this.jmxAppender.getNotificationsInMemory());
                for (Notification notification : persistedNotifications) {
                    SimpleEventQueue.publish((Event)this.getNotificationEvent(notification));
                }
            }
            catch (UndeclaredThrowableException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            SimpleEventQueue.publish((Event)new ConnectionEstablishedEvent(this.id, connectionUrl));
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            SimpleEventQueue.publish((Event)new CloseConnectionEvent(this.id));
            SimpleEventQueue.publish((Event)new ErrorEvent(ErrorEvent.ErrorCode.CONNECTION_COULD_NOT_BE_ESTABLISHED, connectionUrl));
        }
    }

    private NotificationEvent getNotificationEvent(Notification notification) {
        Map userData = (Map)notification.getUserData();
        return new NotificationEvent(this.id, notification.getTimeStamp(), notification.getMessage(), notification.getType(), notification.getSource().toString(), notification.getSequenceNumber(), Level.toLevel((String)((String)userData.get("level"))), (String)userData.get("trace"), (String)userData.get("thread"));
    }

    @Processing(value={CloseConnectionEvent.class})
    public void process(CloseConnectionEvent event) {
        if (event.getId() == this.id) {
            this.disconnect();
        }
    }

    @Override
    public Event getShowConnectionSettingsEvent() {
        return new ShowJmxConnectionSettingsEvent(this);
    }

    public JmxAppenderMBean getJmxAppender() {
        return this.jmxAppender;
    }

    private void disconnect() {
        try {
            this.jmxConnector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getHostAndPort(ConnectionUrl connectionUrl) {
        return connectionUrl.getPathWithoutType().replaceAll("/.+$", "");
    }

    private String getId(ConnectionUrl connectionUrl) {
        return connectionUrl.getPathWithoutType().replaceAll("^.*/", "");
    }

    private class JmxNotificationListener
    implements NotificationListener {
        private JmxNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object data) {
            SimpleEventQueue.publish((Event)JmxConnector.this.getNotificationEvent(notification));
        }
    }

    private class JmxConnectionNotificationListener
    implements NotificationListener {
        private JmxConnectionNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object data) {
            if (notification.getType().equals("jmx.remote.connection.closed")) {
                try {
                    JmxConnector.this.jmxConnector.removeConnectionNotificationListener(JmxConnector.this.jmxNotificationListener);
                }
                catch (ListenerNotFoundException e) {
                    // empty catch block
                }
                try {
                    JmxConnector.this.connection.removeNotificationListener(JmxConnector.this.objectName, JmxConnector.this.jmxConnectionNotificationListener);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SimpleEventQueue.unsubscribe((Object)JmxConnector.this);
                SimpleEventQueue.publish((Event)new ConnectionClosedEvent(JmxConnector.this.id));
            }
        }
    }
}

