/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.domain;

import de.jaggl.logging.mslogger.connectors.Connector;
import de.jaggl.logging.mslogger.connectors.JmsConnector;
import de.jaggl.logging.mslogger.connectors.JmxConnector;
import de.jaggl.logging.mslogger.helpers.SerialNumberHelper;
import java.lang.reflect.Constructor;

public enum ConnectionType {
    JMX("jmx", "[\\d.]+:\\d+/.+", JmxConnector.class),
    JMS("jms", "[\\d.]+:\\d+/.+", JmsConnector.class);

    private String prefix;
    private String pattern;
    private Class<?> connectorClass;

    private ConnectionType(String prefix, String pattern, Class<?> connectorClass) {
        this.prefix = prefix;
        this.pattern = pattern;
        this.connectorClass = connectorClass;
    }

    public Connector getNewConnectorInstance(long id) throws Exception {
        Constructor<?> constructor = this.connectorClass.getConstructor(Long.TYPE);
        return (Connector)constructor.newInstance(id);
    }

    public boolean applies(String path) {
        return path.matches("^" + this.prefix + ":\\/\\/" + this.pattern + "$");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static ConnectionType fromPath(String path) {
        if (SerialNumberHelper.hasValidatedSerialNumber()) {
            for (ConnectionType connectionType : ConnectionType.values()) {
                if (!connectionType.applies(path)) continue;
                return connectionType;
            }
            return null;
        }
        if (JMX.applies(path)) {
            return JMX;
        }
        return null;
    }
}

