/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.domain;

import de.jaggl.logging.mslogger.domain.ConnectionType;

public class ConnectionUrl {
    private String path;
    private ConnectionType type;

    public ConnectionUrl(String path) {
        this.path = path;
        this.type = ConnectionType.fromPath(path);
    }

    public String getPath() {
        return this.path;
    }

    public String getPathWithoutType() {
        return this.path.replaceFirst("^" + this.type.getPrefix() + ":\\/\\/", "");
    }

    public ConnectionType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionUrl other = (ConnectionUrl)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return this.getPath();
    }
}

