/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.helpers;

import de.jaggl.logging.mslogger.helpers.PreferencesHelper;

public class SerialNumberHelper {
    private static final int NUMBER1 = 8;
    private static final int NUMBER2 = 2;
    private static final int NUMBER3 = 6;
    private static final int NUMBER4 = 7;
    private static boolean hasValidatedSerialNumber = false;

    public static boolean hasValidatedSerialNumber() {
        return hasValidatedSerialNumber;
    }

    public static void setHasValidatedSerialNumber(boolean hasValidatedSerialNumber) {
        SerialNumberHelper.hasValidatedSerialNumber = hasValidatedSerialNumber;
    }

    public static boolean validateSerialnumber(String serialnumber) {
        if (!serialnumber.matches("^\\d{4}-\\d{4}-\\d{4}-\\d{4}-\\d{4}$")) {
            return false;
        }
        String[] parts = serialnumber.split("-");
        if (Long.valueOf(parts[0]) % 8L != Long.valueOf(parts[3].substring(0, 1))) {
            return false;
        }
        if (Long.valueOf(parts[1]) % 2L != Long.valueOf(parts[2].substring(0, 1))) {
            return false;
        }
        if (Long.valueOf(parts[3]) % 6L != Long.valueOf(parts[1].substring(0, 1))) {
            return false;
        }
        String partsWithoutHash = String.format("%s-%s-%s-%s", parts[0], parts[1], parts[2], parts[3]);
        int hashCode = partsWithoutHash.hashCode() * 7;
        String hash = String.valueOf(hashCode * Integer.signum(hashCode)).substring(0, 4);
        return hash.equals(parts[4]);
    }

    static {
        hasValidatedSerialNumber = SerialNumberHelper.validateSerialnumber(PreferencesHelper.pref("serialNumber", ""));
    }
}

