/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.helpers;

import de.jaggl.logging.mslogger.events.ShowWindowEvent;
import de.jaggl.utils.events.simple.SimpleEventQueue;
import de.jaggl.utils.events.simple.annotations.Processing;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShowWindowHelper {
    private static final Log log = LogFactory.getLog(ShowWindowHelper.class);
    private static Map<Class<?>, Class<?>> windows = new HashMap();

    public static void addWindowListener(Class<?> eventClass, Class<?> windowClass) {
        windows.put(eventClass, windowClass);
    }

    @Processing(value={ShowWindowEvent.class})
    private void onEvent(ShowWindowEvent event) {
        Class<?> windowClass = windows.get(((Object)((Object)event)).getClass());
        if (windowClass != null) {
            try {
                Object window;
                if (event.getData() == null) {
                    window = windowClass.newInstance();
                } else {
                    Constructor<?> windowConstructor = windowClass.getConstructor(event.getData().getClass());
                    window = windowConstructor.newInstance(event.getData());
                }
                if (JDialog.class.isAssignableFrom(window.getClass())) {
                    ((JDialog)window).setVisible(true);
                } else if (JFrame.class.isAssignableFrom(window.getClass())) {
                    ((JFrame)window).setVisible(true);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        SimpleEventQueue.subscribe((Object)new ShowWindowHelper());
    }
}

