/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.logging.mslogger.helpers;

import com.thoughtworks.xstream.XStream;
import de.jaggl.logging.mslogger.domain.maven.Metadata;
import de.jaggl.logging.mslogger.domain.maven.Versioning;
import de.jaggl.logging.mslogger.domain.maven.Versions;
import de.jaggl.logging.mslogger.helpers.DownloadHelper;
import de.jaggl.logging.mslogger.helpers.JarHelper;
import de.jaggl.logging.mslogger.helpers.LanguageHelper;
import de.jaggl.logging.mslogger.helpers.MavenHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateHelper {
    private static Log log = LogFactory.getLog(UpdateHelper.class);
    private static XStream xStream = new XStream();

    public static void tryUpdate(String repositoryUrl, String groupId, String artifactId, String currentVersion, String classifier) {
        try {
            String serverPath;
            String serverVersion;
            if (JarHelper.isJar() && currentVersion != null && !(serverVersion = UpdateHelper.getCurrentReleaseVersionFromServer(repositoryUrl, groupId, artifactId)).equals(currentVersion) && DownloadHelper.exists(serverPath = MavenHelper.toPath(repositoryUrl, groupId, artifactId, serverVersion, classifier, null)) && JOptionPane.showConfirmDialog(null, LanguageHelper.getText("confirmation.updateNewVersion"), LanguageHelper.getText("confirmation.title"), 0) == 0) {
                DownloadHelper.download(serverPath, JarHelper.currentJar());
                JarHelper.restartApplication();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static String getCurrentReleaseVersionFromServer(String repositoryUrl, String groupId, String artifactId) throws Exception {
        URL versionUrl = new URL(MavenHelper.toPath(repositoryUrl, groupId, artifactId, null, null, null) + "maven-metadata.xml");
        BufferedReader in = new BufferedReader(new InputStreamReader(versionUrl.openStream()));
        String line = null;
        String xml = "";
        do {
            line = in.readLine();
            xml = xml + line;
        } while (line != null);
        in.close();
        return ((Metadata)xStream.fromXML(xml)).getVersioning().getRelease();
    }

    static {
        xStream.processAnnotations(new Class[]{Metadata.class, Versioning.class, Versions.class});
    }
}

