package de.jaggl.spring.jdbc.mappers;

import static de.jaggl.spring.jdbc.namespace.JdbcBeanPostProcessor.DEFAULT_KEY;
import static de.jaggl.utils.common.helpers.MapBuilder.entry;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.springframework.stereotype.Component;

@Component
public class LongMapper implements ExtendedRowMapper<Long>
{

    @Override
    public Long mapRow(ResultSet rs, int rowNum) throws SQLException
    {
        return rs.getString(1) == null ? null : Long.valueOf(rs.getLong(1));
    }

    @Override
    public Map<String, Object> getParams(Long source)
    {
        return entry(DEFAULT_KEY, (Object) source);
    }

}
