package de.jaggl.spring.jdbc.mappers;

import static de.jaggl.spring.jdbc.namespace.JdbcBeanPostProcessor.DEFAULT_KEY;
import static de.jaggl.utils.common.helpers.MapBuilder.entry;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.springframework.stereotype.Component;

@Component
public class StringMapper implements ExtendedRowMapper<String>
{

    @Override
    public String mapRow(ResultSet rs, int rowNum) throws SQLException
    {
        return rs.getString(1);
    }

    @Override
    public Map<String, Object> getParams(String source)
    {
        return entry(DEFAULT_KEY, (Object) source);
    }

}
