package de.jaggl.spring.jdbc.namespace;

import static org.springframework.beans.factory.support.BeanDefinitionBuilder.genericBeanDefinition;
import static org.springframework.beans.factory.support.BeanDefinitionReaderUtils.registerWithGeneratedName;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

import de.jaggl.spring.jdbc.mappers.DoubleMapper;
import de.jaggl.spring.jdbc.mappers.IntegerMapper;
import de.jaggl.spring.jdbc.mappers.LongMapper;
import de.jaggl.spring.jdbc.mappers.StringMapper;

public class JdbcNamespaceHandler extends NamespaceHandlerSupport
{

    @Override
    public void init()
    {
        registerBeanDefinitionParser("annotation-driven",
            new BeanDefinitionParser()
            {

                @Override
                public BeanDefinition parse(Element element,
                    ParserContext parserContext)
                {
                    register(StringMapper.class, parserContext);
                    register(DoubleMapper.class, parserContext);
                    register(IntegerMapper.class, parserContext);
                    register(LongMapper.class, parserContext);
                    register(JdbcBeanPostProcessor.class, parserContext);
                    return null;
                }

                private void register(Class<?> type, ParserContext parserContext)
                {
                    registerWithGeneratedName(genericBeanDefinition(type)
                        .getBeanDefinition(), parserContext.getRegistry());
                }

            });
    }

}
