package de.jaggl.spring.jdbc.queries;

import java.util.Map;

import org.springframework.dao.DataAccessException;

public interface EntryQuery<T>
{

    T findObject(Object[] params, @SuppressWarnings("rawtypes") Map context)
        throws DataAccessException;

    T findObject(Object... params) throws DataAccessException;

    T findObject(int p1, @SuppressWarnings("rawtypes") Map context)
        throws DataAccessException;

    T findObject(int p1) throws DataAccessException;

    T findObject(int p1, int p2, @SuppressWarnings("rawtypes") Map context)
        throws DataAccessException;

    T findObject(int p1, int p2) throws DataAccessException;

    T findObject(long p1, @SuppressWarnings("rawtypes") Map context)
        throws DataAccessException;

    T findObject(long p1) throws DataAccessException;

    T findObject(String p1, @SuppressWarnings("rawtypes") Map context)
        throws DataAccessException;

    T findObject(String p1) throws DataAccessException;

    T findObjectByNamedParam(Map<String, ?> paramMap,
        @SuppressWarnings("rawtypes") Map context) throws DataAccessException;

    T findObjectByNamedParam(Map<String, ?> paramMap)
        throws DataAccessException;

}
