package de.jaggl.spring.jdbc.queries;

import static de.jaggl.spring.jdbc.namespace.JdbcBeanPostProcessor.DEFAULT_KEY;

import java.util.Map;

import javax.sql.DataSource;

import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

import de.jaggl.spring.jdbc.mappers.ExtendedRowMapper;

public class ExtendedJdbcInsert<T> extends SimpleJdbcInsert implements
    InsertQuery<T>
{

    private ExtendedRowMapper<T> mapper;

    private String[] columns;

    public ExtendedJdbcInsert(DataSource dataSource,
        ExtendedRowMapper<T> mapper, String tableName,
        String[] columns, String generatedKeyName)
    {
        super(dataSource);
        withTableName(tableName);
        usingColumns(columns);
        if (generatedKeyName != null)
        {
            setGeneratedKeyName(generatedKeyName);
        }
        compile();
        this.mapper = mapper;
        this.columns = columns;
    }

    @Override
    public int execute(T object)
    {
        return execute(resolveParams(object));
    }

    @Override
    public Number executeAndReturnKey(T object)
    {
        return executeAndReturnKey(resolveParams(object));
    }

    private Map<String, Object> resolveParams(T object)
    {
        if (mapper == null)
        {
            throw new RuntimeException(
                "no ExtendedRowMapper has been set for UpdateQuery (use @MapperClass on field)");
        }
        Map<String, Object> params = mapper.getParams(object);
        if (columns.length == 1 && params.size() == 1
            && params.get(DEFAULT_KEY) != null)
        {
            Object value = params.remove(DEFAULT_KEY);
            params.put(columns[0], value);
        }
        return params;
    }

}
