package de.jaggl.spring.jdbc.queries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.sql.DataSource;

import org.springframework.jdbc.object.SqlUpdate;

import de.jaggl.spring.jdbc.mappers.ExtendedRowMapper;

public class ExtendedSqlUpdate<T> extends SqlUpdate implements
    UpdateQuery
{

    private ExtendedRowMapper<T> mapper;

    public ExtendedSqlUpdate(DataSource dataSource,
        ExtendedRowMapper<T> mapper, String sql,
        int... parameterTypes)
    {
        setDataSource(dataSource);
        setSql(sql);
        setTypes(parameterTypes);
        compile();
        this.mapper = mapper;
    }

    @SuppressWarnings("unchecked")
    @Override
    public int updateObject(Object object, String... usedParamKeys)
    {
        if (mapper == null)
        {
            throw new RuntimeException(
                "no ExtendedRowMapper has been set for UpdateQuery (use @MapperClass on field)");
        }
        Map<String, Object> params = mapper.getParams((T) object);
        if (usedParamKeys.length != 0)
        {
            Map<String, Object> usedParams = new HashMap<String, Object>();
            List<String> usedParamKeysList = new ArrayList<String>(
                Arrays.asList(usedParamKeys));
            for (Entry<String, Object> entry : params.entrySet())
            {
                if (usedParamKeysList.contains(entry.getKey()))
                {
                    usedParams.put(entry.getKey(), entry.getValue());
                }
            }
            params = usedParams;
        }
        return updateByNamedParam(params);
    }

}
