/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.spring.jdbc.namespace;

import de.jaggl.spring.jdbc.annotations.DataSourceQualifier;
import de.jaggl.spring.jdbc.annotations.GeneratedKeyName;
import de.jaggl.spring.jdbc.annotations.MapperClass;
import de.jaggl.spring.jdbc.annotations.SqlQuery;
import de.jaggl.spring.jdbc.annotations.UsingColumns;
import de.jaggl.spring.jdbc.annotations.WithTableName;
import de.jaggl.spring.jdbc.mappers.ExtendedRowMapper;
import de.jaggl.spring.jdbc.queries.EntryQuery;
import de.jaggl.spring.jdbc.queries.ExtendedJdbcInsert;
import de.jaggl.spring.jdbc.queries.ExtendedMappingSqlQuery;
import de.jaggl.spring.jdbc.queries.ExtendedSqlUpdate;
import de.jaggl.spring.jdbc.queries.InsertQuery;
import de.jaggl.spring.jdbc.queries.ListQuery;
import de.jaggl.spring.jdbc.queries.UpdateQuery;
import java.lang.reflect.Field;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.ReflectionUtils;

public class JdbcBeanPostProcessor
implements BeanPostProcessor {
    @Autowired
    private ApplicationContext context;
    public static final String DEFAULT_KEY = "_default_key_";

    public Object postProcessBeforeInitialization(final Object bean, String beanName) throws BeansException {
        final DataSource classDataSource = this.findClassDataSource(bean);
        final RowMapper<?> classRowMapper = this.findClassRowMapper(bean);
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                SqlQuery sqlQuery = field.getAnnotation(SqlQuery.class);
                if (sqlQuery != null) {
                    if (field.getType() == ListQuery.class || field.getType() == EntryQuery.class) {
                        field.setAccessible(true);
                        field.set(bean, new ExtendedMappingSqlQuery(JdbcBeanPostProcessor.this.findFieldDataSource(field, classDataSource), JdbcBeanPostProcessor.this.findFieldRowMapper(field, true, classRowMapper), sqlQuery.value(), sqlQuery.parameterTypes()));
                    } else if (field.getType() == UpdateQuery.class) {
                        RowMapper mapper = JdbcBeanPostProcessor.this.findFieldRowMapper(field, false, classRowMapper);
                        ExtendedRowMapper extMapper = null;
                        if (mapper != null && ExtendedRowMapper.class.isAssignableFrom(mapper.getClass())) {
                            extMapper = (ExtendedRowMapper)mapper;
                        }
                        field.setAccessible(true);
                        field.set(bean, new ExtendedSqlUpdate(JdbcBeanPostProcessor.this.findFieldDataSource(field, classDataSource), extMapper, sqlQuery.value(), sqlQuery.parameterTypes()));
                    } else {
                        throw new RuntimeException("only EntryQuery, ListQuery or UpdateQuery may be annotated with @SqlQuery");
                    }
                }
                if (field.getType() == InsertQuery.class) {
                    WithTableName withTableName = field.getAnnotation(WithTableName.class);
                    UsingColumns usingColumns = field.getAnnotation(UsingColumns.class);
                    GeneratedKeyName generatedKeyName = field.getAnnotation(GeneratedKeyName.class);
                    String keyName = generatedKeyName != null ? generatedKeyName.value() : null;
                    String[] columns = usingColumns != null ? usingColumns.value() : new String[]{};
                    RowMapper mapper = JdbcBeanPostProcessor.this.findFieldRowMapper(field, false, classRowMapper);
                    ExtendedRowMapper extMapper = null;
                    if (mapper != null && ExtendedRowMapper.class.isAssignableFrom(mapper.getClass())) {
                        extMapper = (ExtendedRowMapper)mapper;
                    }
                    if (withTableName == null) {
                        throw new RuntimeException("InsertQuery " + field.getName() + " must be annotated with @WithTableName");
                    }
                    field.setAccessible(true);
                    field.set(bean, new ExtendedJdbcInsert(JdbcBeanPostProcessor.this.findFieldDataSource(field, classDataSource), extMapper, withTableName.value(), columns, keyName));
                }
            }
        });
        return bean;
    }

    private DataSource findClassDataSource(Object bean) {
        DataSourceQualifier dataSourceQualifier = bean.getClass().getAnnotation(DataSourceQualifier.class);
        if (dataSourceQualifier != null) {
            try {
                return (DataSource)this.context.getBean(dataSourceQualifier.value(), DataSource.class);
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        return null;
    }

    private DataSource findFieldDataSource(Field field, DataSource classDataSource) {
        DataSourceQualifier dataSourceQualifier = field.getAnnotation(DataSourceQualifier.class);
        if (dataSourceQualifier != null) {
            try {
                return (DataSource)this.context.getBean(dataSourceQualifier.value(), DataSource.class);
            }
            catch (BeansException e) {
                throw new RuntimeException(e);
            }
        }
        if (classDataSource == null) {
            throw new RuntimeException("no DataSource is configured, use @DataSourceQualifier on field or class!");
        }
        return classDataSource;
    }

    private RowMapper<?> findClassRowMapper(Object bean) {
        MapperClass mapperClass = bean.getClass().getAnnotation(MapperClass.class);
        if (mapperClass != null) {
            try {
                return (RowMapper)this.context.getBean(mapperClass.value());
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        return null;
    }

    private RowMapper<?> findFieldRowMapper(Field field, boolean throwException, RowMapper<?> classRowMapper) {
        MapperClass mapperClass = field.getAnnotation(MapperClass.class);
        if (mapperClass != null) {
            try {
                return (RowMapper)this.context.getBean(mapperClass.value());
            }
            catch (BeansException e) {
                throw new RuntimeException(e);
            }
        }
        if (classRowMapper == null && throwException) {
            throw new RuntimeException("no RowMapper is configured, use @MapperClass on field or class!");
        }
        return classRowMapper;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

