/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.spring.jdbc.queries;

import de.jaggl.spring.jdbc.mappers.ExtendedRowMapper;
import de.jaggl.spring.jdbc.queries.InsertQuery;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

public class ExtendedJdbcInsert<T>
extends SimpleJdbcInsert
implements InsertQuery<T> {
    private ExtendedRowMapper<T> mapper;
    private String[] columns;

    public ExtendedJdbcInsert(DataSource dataSource, ExtendedRowMapper<T> mapper, String tableName, String[] columns, String generatedKeyName) {
        super(dataSource);
        this.withTableName(tableName);
        this.usingColumns(columns);
        if (generatedKeyName != null) {
            this.setGeneratedKeyName(generatedKeyName);
        }
        this.compile();
        this.mapper = mapper;
        this.columns = columns;
    }

    @Override
    public int execute(T object) {
        return this.execute(this.resolveParams(object));
    }

    @Override
    public Number executeAndReturnKey(T object) {
        return this.executeAndReturnKey(this.resolveParams(object));
    }

    private Map<String, Object> resolveParams(T object) {
        if (this.mapper == null) {
            throw new RuntimeException("no ExtendedRowMapper has been set for UpdateQuery (use @MapperClass on field)");
        }
        Map<String, Object> params = this.mapper.getParams(object);
        if (this.columns.length == 1 && params.size() == 1 && params.get("_default_key_") != null) {
            Object value = params.remove("_default_key_");
            params.put(this.columns[0], value);
        }
        return params;
    }
}

