package de.jaggl.spring.jdbc.mappers;

import static de.jaggl.spring.jdbc.namespace.JdbcBeanPostProcessor.DEFAULT_KEY;
import static de.jaggl.utils.common.helpers.MapBuilder.entry;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.springframework.stereotype.Component;

@Component
public class DoubleMapper implements ExtendedRowMapper<Double>
{

    @Override
    public Double mapRow(ResultSet rs, int rowNum) throws SQLException
    {
        return rs.getString(1) != null ? Double.valueOf(rs.getDouble(1)) : null;
    }

    @Override
    public Map<String, Object> getParams(Double source)
    {
        return entry(DEFAULT_KEY, (Object) source);
    }

}
