package de.jaggl.spring.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.object.MappingSqlQuery;

public class ExtendedMappingSqlQuery<T> extends MappingSqlQuery<T> implements
    ListQuery<T>, EntryQuery<T>
{

    private RowMapper<T> mapper;

    public ExtendedMappingSqlQuery(DataSource dataSource, RowMapper<T> mapper,
        String sql, int... parameterTypes)
    {
        setDataSource(dataSource);
        setSql(sql);
        setTypes(parameterTypes);
        compile();
        this.mapper = mapper;
    }

    @Override
    protected T mapRow(ResultSet rs, int rowNum) throws SQLException
    {
        return mapper.mapRow(rs, rowNum);
    }

}
