package de.jaggl.spring.jdbc.queries;

import java.util.List;
import java.util.Map;

import org.springframework.dao.DataAccessException;

public interface ListQuery<T>
{

    List<T> execute(Object[] params, @SuppressWarnings("rawtypes") Map context)
        throws DataAccessException;

    List<T> execute(Object... params) throws DataAccessException;

    List<T> execute(@SuppressWarnings("rawtypes") Map context)
        throws DataAccessException;

    List<T> execute() throws DataAccessException;

    List<T> execute(int p1, @SuppressWarnings("rawtypes") Map context)
        throws DataAccessException;

    List<T> execute(int p1) throws DataAccessException;

    List<T> execute(int p1, int p2, @SuppressWarnings("rawtypes") Map context)
        throws DataAccessException;

    List<T> execute(int p1, int p2) throws DataAccessException;

    List<T> execute(long p1, @SuppressWarnings("rawtypes") Map context)
        throws DataAccessException;

    List<T> execute(long p1) throws DataAccessException;

    List<T> execute(String p1, @SuppressWarnings("rawtypes") Map context)
        throws DataAccessException;

    List<T> execute(String p1) throws DataAccessException;

    List<T> executeByNamedParam(Map<String, ?> paramMap,
        @SuppressWarnings("rawtypes") Map context) throws DataAccessException;

    List<T> executeByNamedParam(Map<String, ?> paramMap)
        throws DataAccessException;

}
