/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.spring.jdbc.queries;

import de.jaggl.spring.jdbc.mappers.ExtendedRowMapper;
import de.jaggl.spring.jdbc.queries.UpdateQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.object.SqlUpdate;

public class ExtendedSqlUpdate<T>
extends SqlUpdate
implements UpdateQuery {
    private ExtendedRowMapper<T> mapper;

    public ExtendedSqlUpdate(DataSource dataSource, ExtendedRowMapper<T> mapper, String sql, int ... parameterTypes) {
        this.setDataSource(dataSource);
        this.setSql(sql);
        this.setTypes(parameterTypes);
        this.compile();
        this.mapper = mapper;
    }

    @Override
    public int updateObject(Object object, String ... usedParamKeys) {
        if (this.mapper == null) {
            throw new RuntimeException("no ExtendedRowMapper has been set for UpdateQuery (use @MapperClass on field)");
        }
        Map<String, Object> params = this.mapper.getParams(object);
        if (usedParamKeys.length != 0) {
            HashMap<String, Object> usedParams = new HashMap<String, Object>();
            ArrayList<String> usedParamKeysList = new ArrayList<String>(Arrays.asList(usedParamKeys));
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (!usedParamKeysList.contains(entry.getKey())) continue;
                usedParams.put(entry.getKey(), entry.getValue());
            }
            params = usedParams;
        }
        return this.updateByNamedParam(params);
    }
}

