package de.jaggl.utils.common.enrichers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import de.jaggl.utils.common.helpers.ReflectionHelper;

public abstract class AbstractEnricher<T> implements
    Enricher<T>
{

    private static final Log log = LogFactory.getLog(AbstractEnricher.class);

    private Class<T> type;

    protected abstract T doEnrich(T object);

    public AbstractEnricher(Class<T> type)
    {
        this.type = type;
    }

    @Override
    public boolean applies(Object object)
    {
        return object.getClass().equals(type);
    }

    @Override
    @SuppressWarnings("unchecked")
    public T enrich(Object object)
    {
        return doEnrich((T) object);
    }

    @Override
    public List<T> enrich(List<T> objects)
    {
        List<T> list = new ArrayList<T>();
        for (T object : objects)
        {
            list.add(enrich(object));
        }
        return list;
    }

    public static <T> T enrichWith(T object, Object data)
    {
        String setterName = "set" + data.getClass().getSimpleName();
        Method setter = ReflectionHelper.findMethod(object.getClass(),
            setterName, data.getClass());
        if (setter != null)
        {
            try
            {
                setter.invoke(object, data);
            }
            catch (Exception e)
            {
                log.error(e.getMessage(), e);
                throw new RuntimeException(e);
            }
        }
        else
        {
            String message = "no setter '" + setterName + "' found for "
                + object.getClass().getName();
            log.error(message);
            throw new RuntimeException(message);
        }
        return object;
    }

    public static <T> List<T> enrichWith(List<T> objects, Object data)
    {
        for (T object : objects)
        {
            object = enrichWith(object, data);
        }
        return objects;
    }

}
