package de.jaggl.utils.common.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;

public class StringHelper
{

    public static String nullToEmpty(Object value)
    {
        if (value == null)
        {
            return "";
        }
        return value.toString();
    }

    public static String emptyToNull(String value)
    {
        if (value == null)
        {
            return null;
        }
        if (value.isEmpty())
        {
            return null;
        }
        return value;
    }

    public static String nl2br(String text)
    {
        if (text == null)
        {
            return null;
        }
        return text.replace("\n", "<br />");
    }

    public static String fromClasspathFile(String path) throws Exception
    {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(path);
        return inputStreamToString(inputStream);
    }

    public static String inputStreamToString(InputStream inputStream)
        throws IOException
    {
        BufferedReader bufferedReader =
            new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder builder = new StringBuilder();
        String line = bufferedReader.readLine();
        while (line != null)
        {
            builder.append(line);
            line = bufferedReader.readLine();
            if (line != null)
            {
                builder.append("\n");
            }
        }
        bufferedReader.close();
        return builder.toString();
    }

    public static String[] split(String input, int maxLength, int maxCount)
    {
        String[] parts = input.split("(?<=\\G.{" + maxLength + "})");
        if (parts.length > maxCount)
        {
            parts = Arrays.asList(parts).subList(0, maxCount)
                .toArray(new String[]
                {});
        }
        return parts;
    }

    public static boolean isSet(String value)
    {
        return value != null && !value.isEmpty();
    }

}
