package de.jaggl.utils.common.listeners;

import static java.awt.event.KeyEvent.VK_ENTER;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class EnterKeyListener extends KeyAdapter
{

    private Runnable runnable;

    public EnterKeyListener(Runnable runnable)
    {
        this.runnable = runnable;
    }

    @Override
    public void keyReleased(KeyEvent event)
    {
        if (event.getKeyCode() == VK_ENTER)
        {
            runnable.run();
        }
    }

}
