/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.utils.common.enrichers;

import de.jaggl.utils.common.enrichers.Enricher;
import de.jaggl.utils.common.helpers.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractEnricher<T>
implements Enricher<T> {
    private static final Log log = LogFactory.getLog(AbstractEnricher.class);
    private Class<T> type;

    protected abstract T doEnrich(T var1);

    public AbstractEnricher(Class<T> type) {
        this.type = type;
    }

    @Override
    public boolean applies(Object object) {
        return object.getClass().equals(this.type);
    }

    @Override
    public T enrich(Object object) {
        return (T)this.doEnrich(object);
    }

    @Override
    public List<T> enrich(List<T> objects) {
        ArrayList<T> list = new ArrayList<T>();
        for (T object : objects) {
            list.add(this.enrich(object));
        }
        return list;
    }

    public static <T> T enrichWith(T object, Object data) {
        String setterName = "set" + data.getClass().getSimpleName();
        Method setter = ReflectionHelper.findMethod(object.getClass(), setterName, data.getClass());
        if (setter != null) {
            try {
                setter.invoke(object, data);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            String message = "no setter '" + setterName + "' found for " + object.getClass().getName();
            log.error((Object)message);
            throw new RuntimeException(message);
        }
        return object;
    }

    public static <T> List<T> enrichWith(List<T> objects, Object data) {
        for (T object : objects) {
            T t = AbstractEnricher.enrichWith(object, data);
        }
        return objects;
    }
}

