/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.utils.common.helpers;

import de.jaggl.utils.common.helpers.ListHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class MultithreadingHelper {
    public static <T extends Runnable> void runMultithreaded(List<T> runnables) throws InterruptedException, ExecutionException {
        MultithreadingHelper.runMultithreaded(runnables, Runtime.getRuntime().availableProcessors());
    }

    public static <E, T extends Callable<E>> List<E> callMultithreaded(List<T> callables) throws InterruptedException, ExecutionException {
        return MultithreadingHelper.callMultithreaded(callables, Runtime.getRuntime().availableProcessors());
    }

    public static <E, T extends Callable<E>> List<E> callMultithreaded(List<T> callables, int maxParallelThreads) throws InterruptedException, ExecutionException {
        Collection<Collection<T>> callableLists = ListHelper.divideInParts(callables, maxParallelThreads);
        ArrayList results = new ArrayList();
        for (Collection<T> callableList : callableLists) {
            ExecutorService executor = Executors.newFixedThreadPool(callableList.size());
            List futures = executor.invokeAll(callableList);
            for (Future future : futures) {
                results.add(future.get());
            }
            executor.shutdown();
        }
        return results;
    }

    public static <T extends Runnable> void runMultithreaded(List<T> runnables, int maxParallelThreads) throws InterruptedException, ExecutionException {
        Collection<Collection<T>> runnableLists = ListHelper.divideInParts(runnables, maxParallelThreads);
        for (Collection<T> runnableList : runnableLists) {
            ExecutorService executor = Executors.newFixedThreadPool(runnableList.size());
            ArrayList futures = new ArrayList();
            for (Runnable runnable : runnableList) {
                futures.add(executor.submit(runnable));
            }
            for (Future future : futures) {
                future.get();
            }
            executor.shutdown();
        }
    }
}

