/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.utils.common.helpers.swing;

import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;

public class AppleHelper {
    public static void initialize(String applicationName, String dockIconResourcePath) {
        AppleHelper.setApplicationName(applicationName);
        AppleHelper.enableScreenMenuBar();
        AppleHelper.disableAboutMenu();
        AppleHelper.setDockIcon(dockIconResourcePath);
    }

    public static void setApplicationName(String applicationName) {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", applicationName);
    }

    public static void enableScreenMenuBar() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    public static void setFullscreen(Window window) {
        try {
            Class<?> clazz = AppleHelper.loadClass("com.apple.eawt.FullScreenUtilities");
            Method method = clazz.getMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE);
            method.invoke(null, window, Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void disableAboutMenu() {
        try {
            Object application = AppleHelper.getApplication();
            Method method = application.getClass().getMethod("setEnabledAboutMenu", Boolean.TYPE);
            method.invoke(application, Boolean.FALSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setDockIcon(String dockIconResourcePath) {
        try {
            BufferedImage image = ImageIO.read(AppleHelper.getClassLoader().getResource(dockIconResourcePath));
            Object application = AppleHelper.getApplication();
            Method method = application.getClass().getMethod("setDockIconImage", Image.class);
            method.invoke(application, image);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object getApplication() throws Exception {
        Class<?> clazz = AppleHelper.loadClass("com.apple.eawt.Application");
        Method method = clazz.getMethod("getApplication", new Class[0]);
        return method.invoke(null, new Object[0]);
    }

    private static ClassLoader getClassLoader() {
        return AppleHelper.class.getClassLoader();
    }

    private static Class<?> loadClass(String name) throws ClassNotFoundException {
        return AppleHelper.getClassLoader().loadClass(name);
    }
}

