/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.utils.common.helpers.swing;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class WindowHelper {
    private static final String ESC = "ESCAPE";

    public static void closeOnExcape(final JDialog dialog) {
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        dialog.getRootPane().getInputMap(2).put(escKeyStroke, ESC);
        dialog.getRootPane().getActionMap().put(ESC, new AbstractAction(){
            private static final long serialVersionUID = 5553616636637049171L;

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        });
    }

    public static void setFullscreen(JFrame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(frame.getGraphicsConfiguration());
        Point location = new Point(insets.left, insets.top);
        Dimension size = new Dimension(screenSize.width - insets.left - insets.right, screenSize.height - insets.top - insets.bottom);
        frame.setLocation(location);
        frame.setSize(size);
    }
}

