package de.jaggl.utils.common.helpers;

import static de.jaggl.utils.common.helpers.ListHelper.divideInParts;
import static java.util.concurrent.Executors.newFixedThreadPool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class MultithreadingHelper
{

    public static <T extends Runnable> void runMultithreaded(List<T> runnables)
        throws InterruptedException, ExecutionException
    {
        runMultithreaded(runnables, Runtime.getRuntime().availableProcessors());
    }

    public static <E, T extends Callable<E>> List<E> callMultithreaded(
        List<T> callables) throws InterruptedException, ExecutionException
    {
        return callMultithreaded(callables, Runtime.getRuntime()
            .availableProcessors());
    }

    public static <E, T extends Callable<E>> List<E> callMultithreaded(
        List<T> callables, int maxParallelThreads)
        throws InterruptedException, ExecutionException
    {
        Collection<Collection<T>> callableLists = divideInParts(callables,
            maxParallelThreads);
        List<E> results = new ArrayList<E>();
        for (Collection<T> callableList : callableLists)
        {
            ExecutorService executor = newFixedThreadPool(callableList.size());
            List<Future<E>> futures = executor.invokeAll(callableList);
            for (Future<E> future : futures)
            {
                results.add(future.get());
            }
            executor.shutdown();
        }
        return results;
    }

    public static <T extends Runnable> void runMultithreaded(List<T> runnables,
        int maxParallelThreads)
        throws InterruptedException, ExecutionException
    {
        Collection<Collection<T>> runnableLists = divideInParts(runnables,
            maxParallelThreads);
        for (Collection<T> runnableList : runnableLists)
        {
            ExecutorService executor = newFixedThreadPool(runnableList.size());
            List<Future<?>> futures = new ArrayList<Future<?>>();
            for (T runnable : runnableList)
            {
                futures.add(executor.submit(runnable));
            }
            for (Future<?> future : futures)
            {
                future.get();
            }
            executor.shutdown();
        }
    }

}
