package de.jaggl.utils.common.helpers;

import static java.util.prefs.Preferences.userRoot;

import java.util.prefs.BackingStoreException;

import de.jaggl.utils.common.helpers.swing.JarHelper;

public class PreferencesHelper
{

    public static String pref(String key, String def)
    {
        return userRoot().node(getNodeName()).get(key, def);
    }

    public static boolean pref(String key, boolean def)
    {
        return userRoot().node(getNodeName()).getBoolean(key, def);
    }

    public static int pref(String key, int def)
    {
        return userRoot().node(getNodeName()).getInt(key, def);
    }

    public static long pref(String key, long def)
    {
        return userRoot().node(getNodeName()).getLong(key, def);
    }

    public static double pref(String key, double def)
    {
        return userRoot().node(getNodeName()).getDouble(key, def);
    }

    public static float pref(String key, float def)
    {
        return userRoot().node(getNodeName()).getFloat(key, def);
    }

    public static byte[] pref(String key, byte[] def)
    {
        return userRoot().node(getNodeName()).getByteArray(key, def);
    }

    public static void setPref(String key, String value)
    {
        userRoot().node(getNodeName()).put(key, value);
    }

    public static void setPref(String key, boolean value)
    {
        userRoot().node(getNodeName()).putBoolean(key, value);
    }

    public static void setPref(String key, int value)
    {
        userRoot().node(getNodeName()).putInt(key, value);
    }

    public static void setPref(String key, long value)
    {
        userRoot().node(getNodeName()).putLong(key, value);
    }

    public static void setPref(String key, double value)
    {
        userRoot().node(getNodeName()).putDouble(key, value);
    }

    public static void setPref(String key, float value)
    {
        userRoot().node(getNodeName()).putFloat(key, value);
    }

    public static void setPref(String key, byte[] value)
    {
        userRoot().node(getNodeName()).putByteArray(key, value);
    }

    public static void clear() throws BackingStoreException
    {
        userRoot().node(getNodeName()).clear();
    }

    private static String getNodeName()
    {
        String path = JarHelper.currentJar();
        if (path.endsWith("/"))
        {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

}
